

# BUILD DIALOG FOR THE VISUALISATION PARAMETERS
proc Visualisation_Dialog {root} {
	set row 0
	grid [label $root.dl -text "Display:"] -row $row -column 0 -sticky e
	grid [checkbutton $root.pts -text "points"   -variable vis_points -command RedrawVisualisation] -row $row -column 1 -sticky w
	incr row
	grid [checkbutton $root.edg -text "edges"    -variable vis_edges  -command RedrawVisualisation] -row $row -column 1 -sticky w
	incr row
	grid [checkbutton $root.ply -text "polygons" -variable vis_polys  -command RedrawVisualisation] -row $row -column 1 -sticky w
	incr row

	grid [label $root.il -text "Depth Scale:"] -row $row -column 0 -sticky e
	grid [scale $root.i -variable depth_scale -from 0.0 -to 5.0 -orient horizontal -resolution 0.001] -row $row -column 1 -sticky ew
	bind $root.i <ButtonRelease> RedrawVisualisation
	bind $root.i <B1-Motion> RedrawVisualisation
	incr row
	
	grid [label $root.al -text "Alpha:"] -row $row -column 0 -sticky e
	grid [scale $root.a -variable vis_alpha -from -180.0 -to 180.0 -orient horizontal -resolution 0.01] -row $row -column 1 -sticky ew
	bind $root.a <ButtonRelease> RedrawVisualisation
	bind $root.a <B1-Motion> RedrawVisualisation
	incr row
	
	grid [label $root.bl -text "Beta:"] -row $row -column 0 -sticky e
	grid [scale $root.b -variable vis_beta -from -180.0 -to 180.0 -orient horizontal -resolution 0.01] -row $row -column 1 -sticky ew
	bind $root.b <ButtonRelease> RedrawVisualisation
	bind $root.b <B1-Motion> RedrawVisualisation
	incr row

	grid [label $root.gl -text "Gamma:"] -row $row -column 0 -sticky e
	grid [scale $root.g -variable vis_gamma -from -180.0 -to 180.0 -orient horizontal -resolution 0.01] -row $row -column 1 -sticky ew
	bind $root.g <ButtonRelease> RedrawVisualisation
	bind $root.g <B1-Motion> RedrawVisualisation
	incr row
	
	grid columnconfigure $root 1 -weight 1

}




