/***
 * 2D MESH VISUALISATION
 * by Norman Feske
 ***/

#include <GL/gl.h>
#include <mesh.h>



/*** LIST OF PUBLIC VARIABLES ***/
char *tcl_symbols = "long vis_points, long vis_edges, long vis_polys, float depth_scale";
char *title = "2D Mesh";

long vis_points=1;
long vis_edges=1;
long vis_polys=1;

float depth_scale=0.25;

typedef mesh visdata;


/* needed parameters: num_hor,num_ver */
visdata *Create_Visualisation(mesh *m) {

	visdata *result;
	mesh_point *srcpt, *dstpt;
	mesh_poly *srcpl, *dstpl;
	long i,j;
	
	if (!m) return (void *)0;
	result = (visdata *)malloc(sizeof(visdata));
	result->num_points=m->num_points;
	result->num_polys=m->num_polys;
	result->points=(mesh_point *)malloc(m->num_points*sizeof(mesh_point));
	result->polys=(mesh_poly *)malloc(m->num_polys*sizeof(mesh_poly));
	
	srcpt=m->points;
	dstpt=result->points;
	for (i=0;i<m->num_points;i++) {
		dstpt->x =srcpt->x;
		dstpt->y =srcpt->y;
		dstpt->z =srcpt->z;
		dstpt->nx=srcpt->nx;
		dstpt->ny=srcpt->ny;
		dstpt->nz=srcpt->nz;
		srcpt++;dstpt++;
	}

	srcpl=m->polys;
	dstpl=result->polys;
	for (i=0;i<m->num_polys;i++) {
		dstpl->num_points = srcpl->num_points;
		dstpl->nx=srcpl->nx;
		dstpl->ny=srcpl->ny;
		dstpl->nz=srcpl->nz;
		for (j=0;j<srcpl->num_points;j++) {
			dstpl->point_idx[j]=srcpl->point_idx[j];
		}
		srcpl++;dstpl++;
	}
	
	return result;
}




void Draw_Visualisation(visdata *v) {
	long i;
	mesh_point *point;
	mesh_poly *poly;
	mesh_point *p1,*p2,*p3;

	if (!v) {
		printf("visdata is zero.\n");
		return;
	}
	if (!v->points) {
		printf("visdata_points is zero.\n");
		return;
	}
	if (!v->num_points) {
		printf("visdata->num_points is zero.\n");
		return;
	}
	
	if (!v->polys) {
		printf("visdata->polys is zero.\n");
		return;	
	}

	if (!v->num_polys) {
		printf("visdata->num_polys is zero.\n");
		return;
	}



	poly=v->polys;
	for (i=0;i<v->num_polys;i++) {
	
		p1=v->points + poly->point_idx[0];
		p2=v->points + poly->point_idx[1];
		p3=v->points + poly->point_idx[2];	

		if (vis_polys) {	
			glBegin(GL_TRIANGLES);
			
			glColor4f(depth_scale*p1->z/256.0,0.0,0.0,0.0);
			glVertex2f(p1->x,p1->y);
			
			glColor4f(depth_scale*p2->z/256.0,0.0,0.0,0.0);
			glVertex2f(p2->x,p2->y);
			
			glColor4f(depth_scale*p3->z/256.0,0.0,0.0,0.0);
			glVertex2f(p3->x,p3->y);		
			glEnd();
		}
		
		if (vis_edges) {
			glBegin(GL_LINES);
			glColor3f(0.8,0.7,0.7);
			glVertex2f(p1->x,p1->y);
			glVertex2f(p2->x,p2->y);
			glVertex2f(p2->x,p2->y);
			glVertex2f(p3->x,p3->y);
			glVertex2f(p3->x,p3->y);
			glVertex2f(p1->x,p1->y);
			glEnd();
		}
		
		poly++;
	}	
	
	if (vis_points) {
		glPointSize(3.0);
		point=v->points;
		for (i=0;i<v->num_points;i++) {
			glBegin(GL_POINTS);
			glColor3f(1.0,1.0,1.0);
			glVertex2f(point->x,point->y);
			glEnd();
			point++;
		}
	}

}



void Destroy_Visualisation(visdata *v) {
	if (!v) return;
	if (v->points) free (v->points);
	if (v->polys) free(v->polys);
	free(v);
}
