#!/usr/bin/wish

puts "showing file: $argv"

set src_fname [lindex $argv 0]
set dst_fname [lindex $argv 1]

set value_list [split [exec cat $src_fname] "\n"]

set max_qerr 0.0
set min_qerr 100000000.0
set num_vals 0

foreach value $value_list {
	if {$value>$max_qerr} {
		set max_qerr $value
	}
	if {$value<$min_qerr} {
		set min_qerr $value
	}
	incr num_vals
}

puts "maximal value: $max_qerr"
puts "minimal value: $min_qerr"
puts "number of values :$num_vals"

set scale 10
set w 600
set h 400

#set xmin -260.0
set xmin [expr -$num_vals / 5.0]
set xmax [expr $num_vals + 20.0]
#set ymin -1.5

set min_truncval [lindex [split $min_qerr "."] 0]
set max_truncval [lindex [split $max_qerr "."] 0]
incr max_truncval

set ymin [expr $min_truncval - 0.5]

set ymax [expr $max_truncval + 0.5]

puts "canvas space: x:$xmin,$xmax y:$ymin,$ymax"
puts "coordinate system: y:$min_truncval,$max_truncval"

proc get_draw_x {xpos} {
  global xmin xmax
  global w
  set zero [expr ($w*abs($xmin)/($xmax-$xmin))]
  return [expr ($xpos*$w)/($xmax-$xmin) + $zero]
}

proc get_draw_y {ypos} {
  global ymin ymax
  global h
  set zero [expr -($h*$ymin/($ymax-$ymin))]
  return [expr $h - (($ypos*$h)/($ymax-$ymin) + $zero)]
}

proc get_real_xpos {drawx} {
  global xmin xmax
  global w
  set zero [expr ($w*abs($xmin)/($xmax-$xmin))]
  return [expr (($xmax-$xmin)*($drawx - $zero))/$w]
}

proc get_real_ypos {drawy} {
  global ymin ymax
  global h
  set zero [expr ($h*abs($ymin)/($ymax-$ymin))]
  return [expr (($ymax-$ymin)*($drawy - $zero))/$h]
}



#wm geometry . 700x300+100+100
set c [canvas .area -relief groove -borderwidth 2 -bg white -width $w -height $h]
frame .bottom
button .bottom.exit -command exit  -text "Exit"
pack .bottom.exit -side left
pack .bottom -side bottom
pack .area -expand yes -fill both -side left



for {set y 0} {$y<$ymax} {incr y} {
	$c create line [get_draw_x 0.0] [get_draw_y $y] [get_draw_x $num_vals] [get_draw_y $y] -width 1 -fill gray
	$c create text [expr [get_draw_x 0.0] - 8] [get_draw_y $y] -text $y
}

for {set x 0} {$x<$num_vals} {incr x 100} {

	$c create line [get_draw_x $x] [get_draw_y $min_truncval] [get_draw_x $x] [get_draw_y [expr $max_truncval]] -width 1 -fill gray
	$c create text [get_draw_x $x] [expr [get_draw_y $min_truncval] + 8] -text [expr $scale*$x]
}

#$c create line [get_draw_x 0.0] [get_draw_y 0.0] [get_draw_x 0.0] [get_draw_y [expr $ymax-1]] -width 2 -fill black -arrow last
#$c create line [get_draw_x 0.0] [get_draw_y 0.0] [get_draw_x $num_vals] [get_draw_y 0] -width 2 -fill black -arrow last


$c create line [get_draw_x 0.0] [get_draw_y $min_truncval] [get_draw_x 0.0] [get_draw_y $max_truncval] -width 2 -fill black -arrow last
$c create line [get_draw_x 0.0] [get_draw_y $min_truncval] [get_draw_x $num_vals] [get_draw_y $min_truncval] -width 2 -fill black -arrow last

$c create text 300 380 -text Iteration
$c create text 50 180 -text "Quantisation\nError"

set first_value [lindex $value_list 0]
set value_list [lrange $value_list 1 end]
set first_x 0
set second_x 1

foreach value $value_list {
	
	$c create line [get_draw_x $first_x] [get_draw_y $first_value] [get_draw_x $second_x] [get_draw_y $value] -width 1 -fill black
	incr first_x
	incr second_x
	set first_value $value
}


$c postscript -fontmap fontMap -colormap -colorMap -file $dst_fname \
			  -x 0 -y 0 -width 600 -height 400
