

# BUILD DIALOG FOR THE NETWORK PARAMETERS
proc Network_Dialog {root} {

	grid [label $root.nhl -text "Init Hor. Nodes:"] -row 0 -column 0 -sticky e
	grid [scale $root.nh -variable num_hor -from 2 -to 50 -orient horizontal] -row 0 -column 1 -sticky ew
	grid [label $root.nvl -text "Init Ver. Nodes:"] -row 1 -column 0 -sticky e
	grid [scale $root.nv -variable num_ver -from 2 -to 50 -orient horizontal] -row 1 -column 1 -sticky ew

	grid [label $root.dl -text "Display:"] -row 2 -column 0 -sticky e
	grid [radiobutton $root.dnix -text "no nodes" -variable disp_nodes -value 0 -command RedrawNetwork] -row 2 -column 1 -sticky w
	grid [radiobutton $root.dn -text "nodes" -variable disp_nodes -value 1 -command RedrawNetwork] -row 3 -column 1 -sticky w
	grid [radiobutton $root.dcn -text "weighted nodes" -variable disp_nodes -value 2 -command RedrawNetwork] -row 4 -column 1 -sticky w
	grid [checkbutton $root.dc -text "connections" -variable disp_connections -command RedrawNetwork] -row 5 -column 1 -sticky w
	
	grid [label $root.al -text "Annealing:"] -row 6 -column 0 -sticky e
	grid [radiobutton $root.aglob -text "global" -variable per_node -value 0 -command RedrawNetwork] -row 6 -column 1 -sticky w
	grid [radiobutton $root.anode -text "per node" -variable per_node -value 1 -command RedrawNetwork] -row 7 -column 1 -sticky w
	
	grid [label $root.il -text "Iterations per step:"] -row 8 -column 0 -sticky e
	grid [scale $root.i -variable iterations -from 1 -to 10000 -orient horizontal] -row 8 -column 1 -sticky ew

	grid [label $root.mil -text "Max. Iterations:"] -row 9 -column 0 -sticky e
	grid [scale $root.mi -variable max_iterations -from 1 -to 10000 -orient horizontal] -row 9 -column 1 -sticky ew
	
	grid [label $root.ial -text "Initial Adaption:"] -row 10 -column 0 -sticky e
	grid [scale $root.ia -variable adaption_init -from 0.001 -to 1.0 -orient horizontal -resolution 0.001] -row 10 -column 1 -sticky ew

	grid [label $root.fal -text "Final Adaption:"] -row 11 -column 0 -sticky e
	grid [scale $root.fa -variable adaption_end -from 0.001 -to 1.0 -orient horizontal -resolution 0.001] -row 11 -column 1 -sticky ew
	
	grid columnconfigure $root 1 -weight 1

}




