

# BUILD DIALOG FOR THE NETWORK PARAMETERS
proc Network_Dialog {root} {

	set row 0
	grid [label $root.nhl -text "Init Hor. Nodes:"] -row $row -column 0 -sticky e
	grid [scale $root.nh -variable num_hor -from 2 -to 50 -orient horizontal] -row $row -column 1 -sticky ew
	incr row
	grid [label $root.nvl -text "Init Ver. Nodes:"] -row $row -column 0 -sticky e
	grid [scale $root.nv -variable num_ver -from 2 -to 50 -orient horizontal] -row $row -column 1 -sticky ew
	incr row
	grid [label $root.dl -text "Display:"] -row $row -column 0 -sticky e
	grid [checkbutton $root.dc -text "connections" -variable disp_connections -command RedrawNetwork] -row $row -column 1 -sticky w
	incr row
	grid [label $root.il -text "Iterations per Step:"] -row $row -column 0 -sticky e
	grid [scale $root.i -variable iterations -from 1 -to 100 -orient horizontal] -row $row -column 1 -sticky ew
	incr row
	grid [label $root.ail -text "Initial Adaption:"] -row $row -column 0 -sticky e
	grid [scale $root.ai -variable adaption_init -from 0.01 -to 1.0 -orient horizontal -resolution 0.001] -row $row -column 1 -sticky ew
	incr row
	grid [label $root.ael -text "Final Adaption:"] -row $row -column 0 -sticky e
	grid [scale $root.ae -variable adaption_end -from 0.01 -to 1.0 -orient horizontal -resolution 0.001] -row $row -column 1 -sticky ew
	incr row
	grid [label $root.vil -text "Initial Viscosity:"] -row $row -column 0 -sticky e
	grid [scale $root.vi -variable lambda_init -from 0.1 -to 50.0 -orient horizontal -resolution 0.01] -row $row -column 1 -sticky ew
	incr row
	grid [label $root.vel -text "Final Viscosity:"] -row $row -column 0 -sticky e
	grid [scale $root.ve -variable lambda_end -from 0.1 -to 50.0 -orient horizontal -resolution 0.01] -row $row -column 1 -sticky ew
	incr row
	grid [label $root.mil -text "Max.Iterations:"] -row $row -column 0 -sticky e
	grid [scale $root.mi -variable max_iterations -from 1 -to 5000 -orient horizontal] -row $row -column 1 -sticky ew

	grid columnconfigure $root 1 -weight 1

}




