
struct mesh_point {
	float x,y,z;		/* point coordinates */
	float nx,ny,nz;		/* normal vector of point */
};

typedef struct mesh_point mesh_point;

/* we are only using triangles... */
#define MAX_POLYPOINTS 3

struct mesh_poly {
	long num_points;	/* number of polygon points */
	long point_idx[MAX_POLYPOINTS];	/* array with polygon point indices */
	float nx,ny,nz;		/* normal vector of polygon */
};

typedef struct mesh_poly mesh_poly;


struct mesh {
	long num_points;	/* number of mesh points */
	mesh_point *points;	/* pointer to point array */
	long num_polys;		/* number of polygons */
	mesh_poly *polys;	/* pointer to polygon array */
};

typedef struct mesh mesh;

void Delaunay_Mesh(mesh *m);
void Destroy_Mesh(mesh *m);
void Calc_Mesh_Normals(mesh *m);
void Draw_Mesh(mesh *m);

