#include "stdio.h"
#include "stdlib.h"
#include "image.h"



/*** RETURNS THE NUMBER OF BYTES PER PIXEL OF A SPECIFIED IMAGE FORMAT ***/
long Get_Pixel_Size(int format) {
	switch (format) {
	case IMAGE_GRAY_FLOAT:
	case IMAGE_RGBA_CHAR: 
		return 4;
	}
	return 4;
}



/*** CREATE NEW IMAGE OF THE SPECIFIED PIXEL SIZE AND PIXEL FORMAT ***/
image *Create_Image(long w,long h,int format) {
	image *result=(image *)malloc(sizeof(image));
	result->w=w;
	result->h=h;
	result->format=format;
	result->pixels=(void *)malloc(w*h*Get_Pixel_Size(format));
	return result;
}



/*** LOAD AN UNPACKED SGI RGB IMAGE AND CONVERTS IT TO THE SPECIFIED FORMAT ***/
image *Load_RGB_Image(char *filename,int format) {
	long 	i;
	FILE *fh;
	unsigned char *src;
	float *dst_float;
	unsigned char *dst_char;
	unsigned char *header;
	unsigned char *channel_buffer;
	long w,h;
	image *result;
	
	fh=fopen(filename,"r");
	if (fh==(void *)0) return (void *)0;
	
	result=(image *)malloc(sizeof(image));
	
	/* determine image size */
	header=(unsigned char *)malloc(512);
	fread(header,2,256,fh);
	w=((long)(*(header+6)))*256 + (long)(*(header+7));
	h=((long)(*(header+8)))*256 + (long)(*(header+9));
	printf("width %ld height %ld\n",w,h);
	free(header);
	result->w=w;
	result->h=h;
	result->format=format;
	
	if ((w<16) || (h<16) || (w*h>1000000)) {
		free(result);
		return (void *)0;
	}
	

	switch ((int)format) {

	case IMAGE_GRAY_FLOAT:

		result=Create_Image(w,h,format);

		/* read red channel */
		channel_buffer=(char *)malloc(w*h);
		fread(channel_buffer,1,w*h,fh);
		src=channel_buffer;
		dst_float=(float *)result->pixels;
		for (i=0;i<w*h;i++) *(dst_float++)=*(src++);

		/* read green channel */
		fread(channel_buffer,1,w*h,fh);
		src=channel_buffer;
		dst_float=(float *)result->pixels;
		for (i=0;i<w*h;i++) *(dst_float++)+=*(src++);

		/* read blue channel */
		fread(channel_buffer,1,w*h,fh);
		src=channel_buffer;
		dst_float=(float *)result->pixels;
		for (i=0;i<w*h;i++) {
			*dst_float+=*(src++);
			*dst_float=*dst_float/3.0;
			dst_float++;
		}

		free(channel_buffer);	
		break;

	case IMAGE_RGBA_CHAR:
		result=Create_Image(w,h,format);

		/* read red channel */
		channel_buffer=(char *)malloc(w*h);
		fread(channel_buffer,1,w*h,fh);
		src=channel_buffer;
		dst_char=(unsigned char *)result->pixels;
		for (i=0;i<w*h;i++) *(dst_char+=4)=*(src++);

		/* read green channel */
		fread(channel_buffer,1,w*h,fh);
		src=channel_buffer;
		dst_char=(unsigned char *)result->pixels + 1;
		for (i=0;i<w*h;i++) *(dst_char+=4)+=*(src++);

		/* read blue channel */
		fread(channel_buffer,1,w*h,fh);
		src=channel_buffer;
		dst_char=(unsigned char *)result->pixels + 2;
		for (i=0;i<w*h;i++) *(dst_char+=4)+=*(src++);

		free(channel_buffer);	
		break;
	}
	fclose(fh);
	return result;
}






/*** FREE THE MEMORY OF AN IMAGE ***/
void Destroy_Image(image *img) {
	if (img) {
		if (img->pixels) free(img->pixels);
		free(img);
	}
}



/*** CONVERTS FLOAT GRAYSCALE IMAGE INTO RGBA IMAGE ***/
image *Image_float2rgba (image *src,image *dst) {
	long i;
	long w=src->w,h=src->h;
	char value;
	long num_pixels=w*h;
	char  *dst_pix;
	float *src_pix;

	if (dst==NULL) dst=Create_Image(w,h,IMAGE_RGBA_CHAR);
	if ((dst->w!=w) || (dst->h!=h)) {
		Destroy_Image(dst);
		dst=Create_Image(w,h,IMAGE_RGBA_CHAR);
	}

	src_pix=src->pixels;
	dst_pix=dst->pixels;
	
	for (i=0;i<num_pixels;i++) {
		value=(char)(*(src_pix++));
		*(dst_pix++)=value;
		*(dst_pix++)=value;
		*(dst_pix++)=value;
		dst_pix++;
	}
	return dst;
}

