
#include <pthread.h>

#include <stdio.h>
#include <GL/glut.h>

#include "handle_gl.h"



/*** defined in main.c ***/
extern int network_win_id;
extern int result_win_id;

extern void glut_redraw_network(void);
extern void glut_redraw_result(void);

/*
void redraw(void) {
    glClear(GL_COLOR_BUFFER_BIT);
	glutSwapBuffers();
}
*/


void reshape(int w, int h) {
	glViewport (0, 0, w, h);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	glOrtho(0, w, 0, h,-99999.0,99999.0);
}


long gl_ready=0;
void idle(void) {
    gl_ready=1;
}



int glut_argc=1;
char *glut_arg1="dummyname";
char **glut_args=&glut_arg1;

void *do_glut_mainloop(void *arg) {

	glutInit(&glut_argc,glut_args);

	glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
	glutInitWindowSize(200,100);
	network_win_id=glutCreateWindow("VNNlab Network");

        /*
         * Disable stuff that's likely to slow down
         * glDrawPixels.(Omit as much of this as possible,
         * when you know in advance that the OpenGL state is
         * already set correctly.)
         */

	glShadeModel (GL_FLAT);

        glEnable(GL_ALPHA_TEST);
        glDisable(GL_BLEND);
        glDisable(GL_DEPTH_TEST);
        glDisable(GL_DITHER);
        glDisable(GL_FOG);
        glDisable(GL_LIGHTING);
        glDisable(GL_LOGIC_OP);
        glDisable(GL_STENCIL_TEST);
        glDisable(GL_TEXTURE_1D);
        glDisable(GL_TEXTURE_2D);

        glPixelTransferi(GL_MAP_COLOR, GL_FALSE);
        glPixelTransferi(GL_RED_SCALE, 1);
        glPixelTransferi(GL_RED_BIAS, 0);
        glPixelTransferi(GL_GREEN_SCALE, 1);
        glPixelTransferi(GL_GREEN_BIAS, 0);
        glPixelTransferi(GL_BLUE_SCALE, 1);
        glPixelTransferi(GL_BLUE_BIAS, 0);
        glPixelTransferi(GL_ALPHA_SCALE, 1);
        glPixelTransferi(GL_ALPHA_BIAS, 0);



	glutDisplayFunc(glut_redraw_network);
	glutIdleFunc(idle);
	glutReshapeFunc(reshape);
	
	glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE|GLUT_DEPTH);
	glutInitWindowSize(200,100);
	result_win_id=glutCreateWindow("VNNlab Result");
	glutDisplayFunc(glut_redraw_result);
//	glutIdleFunc(idle);
	glutReshapeFunc(reshape);

    glDepthFunc(GL_LEQUAL);
    glEnable(GL_DEPTH_TEST);
    
    /* Interpolation auf Polygonen aktivieren */
    glShadeModel(GL_SMOOTH);

	
	glutMainLoop();
	return NULL;
}


pthread_t gl_thread;

void Init_OpenGL(void) {
	pthread_create(&gl_thread,NULL,&do_glut_mainloop,NULL);
	while (!gl_ready);
}






