option add *Label*font {Helvetica -12}
option add *close*background #99aabb
option add *Scale*borderWidth 1


### DEFINE MODULE TYPES ###
set modtypes [list dist net depth vis]

set module(dist,name) "sobel"
set module(dist,location) "distributions"
set module(dist,win_title) "VNNlab Distribution"
set module(dist,menu_text) "Distribution"
set module(dist,tcl_initcmd) "Distribution_Dialog"
set module(dist,functions) [list Create_Distribution \
                                 Destroy_Distribution \
								 Get_Distribution \
								 Draw_Distribution \
								 Get_Distribution_Width \
								 Get_Distribution_Height]

set module(net,name) "lvq"
set module(net,location) "networks"
set module(net,win_title) "VNNlab Network"
set module(net,menu_text) "Network"
set module(net,tcl_initcmd) "Network_Dialog"
set module(net,functions) [list Create_Network \
                                Destroy_Network \
								Draw_Network \
								Compute_Network \
								Compute_Error \
								Export_Mesh]

set module(depth,name) "bm"
set module(depth,location) "depthevals" 
set module(depth,win_title) "VNNlab Depth Evaluation"
set module(depth,menu_text) "Depth-Evaluation"
set module(depth,tcl_initcmd) "DepthEval_Dialog"
set module(depth,functions) [list Init_DepthEval \
                                  Deinit_DepthEval \
								  Get_Similarity \
								  Get_Disparity]

set module(vis,name) "mesh2d"
set module(vis,location) "visualisations"
set module(vis,win_title) "VNNlab Visualisation"
set module(vis,menu_text) "Visualisation"
set module(vis,tcl_initcmd) "Visualisation_Dialog"
set module(vis,functions) [list Create_Visualisation \
                                Draw_Visualisation \
								Destroy_Visualisation]


### RETURNS THE FILENAME OF THE SHARED OBJECT FILE OF THE SPECIFIED MODULE ###
proc get_module_so_fname {modtype modname} {
	global module
	set folder $module($modtype,location)
	return "$folder/$modname/$modname.so"
}


### RETURNS THE FILENAME OF THE TCL/TK SCRIPT OF THE SPECIFIED MODULE ###
proc get_module_tcl_fname {modtype modname} {
	global module
	set folder $module($modtype,location)
	return "$folder/$modname/$modname.tcl"
}


### EXTRACT INFORMATION ABOUT SHARED VARIABLES OF A SHARED OBJECT ###
# module_so is the handle of the shared object
proc extract_shared_vars { module_so } {
	global sym_type sym_adr
	set sym_list [split [dlGetString $module_so tcl_symbols] ,]
	set symbols {}
	foreach sym $sym_list {
		set type [lindex $sym 0]
		set name [lindex $sym 1]
		set adr  [dlGetAdress $module_so $name]
		set value [dlPeek $adr $type]
		set $name $value

		puts " $name (type: $type, adress: $adr, value: $value)"
	
		lappend symbols $name
		set sym_type($module_so,$name) $type
		set sym_adr($module_so,$name) $adr
	}
	return $symbols
}


proc update_tcl_syms {module_so symbols} {
	global sym_type sym_adr
	
	foreach sym $symbols {
		global $sym
		set $sym [dlPeek $sym_adr($module_so,$sym) $sym_type($module_so,$sym)]
	}
}


### RETURNS THE TITLE OF THE SPECIFIED MODULE ###
proc get_module_title {modtype modname} {
	set dl_handle [dlOpen [get_module_so_fname $modtype $modname]]
	if {$dl_handle==0} {
		return "No title defined!"
	}
	set mod_title [dlGetString $dl_handle title]
	dlClose $dl_handle
	return $mod_title
}


### CHECKS IF A MODULE FEATURES ALL NEEDED FUNCTIONS ###
proc module_is_valid {modtype modname} {
	global module
	set dl_handle [dlOpen [get_module_so_fname $modtype $modname]]
	if {$dl_handle==0} {
		return "    ERROR: No shared object found!"
	}
	foreach function $module($modtype,functions) {
 		if {[dlGetAdress $dl_handle $function]=="not defined"} {
			return "    ERROR: undefined Function: $function"
		}
	}
	dlClose $dl_handle
	return "ok"
}


### SCAN THE GIVEN MODULE PATH FOR MODULE SUBDIRECTORIES, ###
### REQUEST MODULE TITLES AND RETURN A LIST WITH THE MODULE INFORMATION ###
proc scan_modules {modtype} {
	global module
	set module_path $module($modtype,location)
	print "scanning modules in directory: $module_path..."

	set ls_out [exec ls -l $module_path]
	set ls_list [split $ls_out "\n"]
	set ls_list [lrange $ls_list 1 end]
	set mod_list {}
	foreach l $ls_list {
		# check if direntry is a directory
		if {[string match d* $l]} {
			set modname [lindex $l 8]
			set modtitle [get_module_title $modtype $modname]
			print "  MODULE: $modname "
			print "    TITLE: $modtitle"
			set modval [module_is_valid $modtype $modname]
			if {$modval=="ok"} {
				lappend mod_list $modname
			} else {
				print $modval			
			}
		}
	}
	return $mod_list
}


### ACTIVATE NEW MODULE WITH SPECIFIED NAME AND TYPE ###
proc set_new_module {modtype modname} {
	global module
	
	PrepareModuleChange $modtype;
	if {[info exists module($modtype,so_handle)]} {
		set old_so_handle $module($modtype,so_handle)
	}
	set module($modtype,name) $modname
	set module($modtype,so_handle) [dlOpen [get_module_so_fname $modtype $modname]]
	source [get_module_tcl_fname $modtype $modname]
	
	if {[winfo exists .$modtype]} {
		.$modtype.title configure -text [get_module_title $modtype $modname]

		destroy .$modtype.dialog
		frame .$modtype.dialog -relief raised -borderwidth 2
		$module($modtype,tcl_initcmd) .$modtype.dialog
		pack .$modtype.dialog -expand yes -fill both -after .$modtype.title	
	}
		
	SetModule $modtype $module($modtype,so_handle)
	puts "shared variables of $modtype module:"
	set module($modtype,symbols) [extract_shared_vars $module($modtype,so_handle)]
	update_tcl_syms $module($modtype,so_handle) $module($modtype,symbols)

	# update user interface
	switch $modtype {
		dist {
			if {[winfo exists .net.bf.learn]} {
				.net.bf.learn configure -relief raised 			
			}
			RedrawDistribution
		}
		net {
			if {[winfo exists .net.bf.learn]} {
				.net.bf.learn configure -relief raised 			
			}
			RedrawNetwork
		}
		depth {
			RedrawVisualisation
		}
		vis {
			RedrawVisualisation
		}
	}
	if {[info exists old_so_handle]} {
		dlClose $old_so_handle
	}
}


### BUILD DIALOG WINDOW FOR THE SPECIFIED MODULE TYPE ###
proc build_dialog {modtype} {
	global module
	if {[winfo exists .$modtype]} return
	toplevel .$modtype
	wm title .$modtype $module($modtype,win_title)
	label .$modtype.title -text [dlGetString $module($modtype,so_handle) title] -font "-*-*-*-*-*-*-15-*-*-*-*-*-*-*"
	frame .$modtype.dialog -relief raised -borderwidth 2
	$module($modtype,tcl_initcmd) .$modtype.dialog
	pack .$modtype.title
	pack .$modtype.dialog -expand yes -fill both
	frame .$modtype.bf

	switch $modtype {
		dist {
			pack [button .dist.bf.init -text "Create" -command InitDistribution] -side left		
		}
		net {
			pack [button .net.bf.init -text "Init" -command InitNetwork] -side left
			pack [button .net.bf.learn -text "Learn" -command {
				BeginLearning
				.net.bf.learn configure -relief sunken 
			}] -side left
			pack [button .net.bf.stop -text "Stop" -command {
				StopLearning
				.net.bf.learn configure -relief raised 
			}] -side left
			pack [button .net.bf.step -text "Step" -command {
				BeginLearning
				StopLearning
				.net.bf.learn configure -relief raised 
			}] -side left
		}
		depth {
			pack [button .depth.bf.init -text "Init" -command InitDepthEval] -side left
		}
		vis {
			pack [button .vis.bf.update -text "Update" -command UpdateVisualisation] -side left
			pack [button .vis.bf.ani -text "Animate" -command {
				StartVisAnimation
				.vis.bf.ani configure -relief sunken 
			}] -side left
			pack [button .vis.bf.stop -text "Stop" -command {
				StopVisAnimation
				.vis.bf.ani configure -relief raised 
			}] -side left		
		}
	}
	
	pack [button .$modtype.bf.close -text "Close" -command "destroy .$modtype"] -side right
	pack .$modtype.bf -expand yes -fill x -padx 5 -pady 5
}


source "console.tcl"


### LOAD MODULES ###
foreach modtype $modtypes {
	set_new_module $modtype $module($modtype,name)
}


### BUILD MAIN WINDOW ###
frame .mf
foreach modtype $modtypes {
	menubutton .mf.$modtype -text $module($modtype,menu_text) -menu .mf.$modtype.menu
	set modmenu [menu .mf.$modtype.menu -tearoff 1]
	foreach modname [scan_modules $modtype] {
		set title [get_module_title $modtype $modname]
		$modmenu add command -label "$modname ($title)" -command "set_new_module $modtype $modname"
	}
	pack .mf.$modtype -side left
}
pack .mf -expand yes -fill x
source "diagram.tcl"
frame .bf
pack [button .bf.exit -command exit -text "Exit"] -padx 5 -pady 5 -side left
pack [button .bf.console -command open_console -text "Open Console"] -padx 5 -pady 5 -side left
pack .bf

