set src_img_fname "chr_left.rgb"

# BUILD DIALOG FOR THE DISTRIBUTION PARAMETERS
proc Distribution_Dialog {root} {
	global src_img_fname

	grid [label $root.sil -text "Source Image:"] -row 0 -column 0 -sticky e
	grid [entry $root.si -textvariable src_img_fname -state disabled] -row 0 -column 1 -sticky ew
	bind $root.si <ButtonRelease-1> "
		set fname \[tk_getOpenFile\]
		if {\$fname!=\"\"} {
			set src_img_fname \$fname
		}
		$root.si xview end
		InitDistribution
	"

	grid [label $root.trl -text "Threshold:"] -row 1 -column 0 -sticky e
	grid [scale $root.tr -variable threshold -from 1 -to 100 -orient horizontal] -row 1 -column 1 -sticky ew
	bind $root.tr <ButtonRelease-1> InitDistribution
	grid [label $root.osl -text "Offset:"] -row 2 -column 0 -sticky e
	grid [scale $root.os -variable stepsize -from 1 -to 5 -orient horizontal] -row 2 -column 1 -sticky ew
	bind $root.os <ButtonRelease-1> InitDistribution

	grid [label $root.dl -text "Display:"] -row 3 -column 0 -sticky e
	grid [radiobutton $root.dnix   -text "nothing"        -variable disp_bg -value 0 -command RedrawDistribution] -row 3 -column 1 -sticky w
	grid [radiobutton $root.dorig  -text "original image" -variable disp_bg -value 1 -command RedrawDistribution] -row 4 -column 1 -sticky w
	grid [radiobutton $root.dsobel -text "sobel filtered" -variable disp_bg -value 2 -command RedrawDistribution] -row 5 -column 1 -sticky w
	grid [radiobutton $root.ddist  -text "distribution"   -variable disp_bg -value 3 -command RedrawDistribution] -row 6 -column 1 -sticky w
		
	grid columnconfigure $root 1 -weight 1

}




