
### GENERATE WIDGET TREE FOR DISPLAYING THE BLOCK DIAGRAM ###
proc Build_Diagram {root} {

	set diag_bg #aabbcc
	set c [canvas $root.c -width 770 -height 200 -bg $diag_bg -borderwidth 0]

	# DRAW ARROWS #
	
	set x 20
	set xinc 130
	set y 50
	
	# draw arrows between the computation boxes
	set x1 100
	set x2 150
	set ty [expr $y - 5]
	set arrowlabels {dist points 2D-mesh 3D-mesh surface}
	
	foreach al $arrowlabels {
		$c create line $x1 $y $x2 $y -arrow last
		$c create text [expr $x1+2] $ty -text $al -anchor w -font -*-*-medium-r-*-*-7-*-*-*-*-*-*-*
		incr x1 $xinc
		incr x2 $xinc
	}
	
	# draw arrows to the display boxes
	set oy 115
	set uy 75
	$c create line 60 $uy 90 $oy -arrow last
	$c create line 190 $uy 160 $oy -arrow last
	$c create line 710 $uy 680 $oy -arrow last

	# DRAW BOXES

	set boxes {}
	set box_bg #bfccd9
	set w 80
	set h 50	
	# computing boxes 
	lappend boxes [list b1 $x $y $w $h "Distribution" "build_dialog dist" module(dist,name)]
	incr x $xinc
	lappend boxes [list b2 $x $y $w $h "Network" "build_dialog net" module(net,name)]
	incr x $xinc
	lappend boxes [list b3 $x $y $w $h "Build\nMesh" "" ""]
	incr x $xinc
	lappend boxes [list b4 $x $y $w $h "Eval Depth" "build_dialog depth" module(depth,name)]
	incr x $xinc
	lappend boxes [list b5 $x $y $w $h "Calculate\nNormals" "" ""]
	incr x $xinc
	lappend boxes [list b6 $x $y $w $h "Visualisation" "build_dialog vis" module(vis,name)]
	
	# output boxes
	lappend boxes [list b7 90 150 70 70 "Network\nDisplay" "" ""]
	lappend boxes [list b8 610 150 70 70 "Result\nDisplay" "" ""]

	foreach b $boxes {
		set widg [lindex $b 0]
		set xpos [lindex $b 1]
		set ypos [lindex $b 2]
		set width [lindex $b 3]
		set height [lindex $b 4]
		set name [lindex $b 5]
		set cmd  [lindex $b 6]
		set txtvar [lindex $b 7]

		frame $c.$widg -relief raised -borderwidth 2 -bg $box_bg
		label $c.$widg.l -text $name -bg $box_bg -font "Helvetica -12"
		if {$cmd!=""} {
			button $c.$widg.b -relief groove -bg $box_bg -text Options... -command $cmd
			pack $c.$widg.l 
			pack $c.$widg.b
		} else {
			pack $c.$widg.l -expand yes
		}
		$c create window $xpos $ypos -window $c.$widg -anchor w -width $width -height $height
		if {$txtvar!=""} {
			label $c.l$widg -textvariable $txtvar -fg #445566 -font "Helvetica -10" -bg $diag_bg
			$c create window $xpos [expr $ypos - $height / 2] -window $c.l$widg -anchor sw -width $width
		}
	}
		
	pack $root.c
}


set dummy Hallo

frame .dg -borderwidth 2 -relief raised
Build_Diagram .dg

pack .dg
