/****************************************************
 *
 * PROGRAM USES PTHREADS (OPENGL WINDOW IS A THREAD)
 *
 ****************************************************/


#include <stdlib.h>
#include <tk.h>
#include <tcl.h>
#include <dlfcn.h>
#include <unistd.h>
#include <signal.h>
#include <pthread.h>

#include <sys/stat.h>
#include <fcntl.h>

#include <math.h>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glut.h>

#include "../image.h"

long depth_win_id;
long depth_initflag=0;

long img_w=50,img_h=50;
image *view_l_img=(void *)0;
image *view_r_img=(void *)0;
image *view_d_img=(void *)0;
image *calc_d_img=(void *)0;

int cursor_x=0,cursor_y=0;

char TCL_result[256];
char *errormsg;
Tcl_Interp *interp;

/* only for debugging */
void check_dlerror(char *ident) {
	errormsg = dlerror();
	if (errormsg != NULL) printf("dlerror [%s]: %s\n",ident,errormsg);
}



/*** SOME FUNCTIONS TO CONVERT DATATYPES ***/
char *ptoa(void *p,char *as) {
	sprintf(as,"%lu",(long)p);
	return as;
}

char *ltoa(long l,char *as) {
	sprintf(as,"%lu",l);
	return as;
}

char *ftoa(float f,char *as) {
	sprintf(as,"%f",f);
	return as;
}

void *atop(char *as) {
	return (void *)atol(as);
}



void *depth;
void *depth_so;


long dist_w=200,dist_h=100;


/******************************
 *                            
 * VARIABLE SYNCHRONISATION
 *
 ******************************/


char *fetch_symbol(char *curr_sym,char *dst_type,char *dst_name) {

	/* ignore space at the beginning */
	while (*curr_sym==' ') curr_sym++;

	/* the first component of the symbol is the type */
	/* copy type to dst_type until a space or stringend appears */
	while ((*curr_sym!=' ') && (*curr_sym!=',') && (*curr_sym!=0)) {
		*(dst_type++)=*(curr_sym++);
	}
	
	*(dst_type++)=0; /* terminate type string */
	
	if (*(curr_sym-1) == 0) {
		*dst_name=0;
		return (char *)0;
	}
	
	/* ignore space between type and name */
	while (*curr_sym==' ') curr_sym++;
	
	/* now comes the name */
	while ((*curr_sym!=',') && (*curr_sym!=0)) {
		(*dst_name++)=(*curr_sym++);
	}
	
	*(dst_name++)=0; /* terminate name string */
	
	/* check if the last symbol was zero */
	if (*(curr_sym)==0) {
		return (char *)0;
	}
	
	/* check if the last symbol was a comma */
	if (*(curr_sym)==',') {
		return curr_sym+1;
	}
	

}


/*** UPDATES THE SHARED C VARIABLES OF A SHARED OBJECT ***/
void update_so_vars(void *so) {
	static char sym_type[256];
	static char sym_name[256];
	char **so_vars;
	char *new_value;
	void *sym_adr;
	char *curr_pos;
	
	so_vars = (char **)dlsym(so,"tcl_symbols");
	curr_pos=*so_vars;
	check_dlerror("tcl_symbols");

//	printf("symbols: %s\n",curr_pos);
	
	while (curr_pos) {
	
		curr_pos=fetch_symbol(curr_pos,sym_type,sym_name);
//		printf("symbol type: %s, ",sym_type);
//		printf("name: %s, ",sym_name);

		sym_adr=dlsym(so,sym_name);
		check_dlerror("shared variable");

		new_value=Tcl_GetVar(interp,sym_name,0);
//		printf("new value: %s\n",new_value);
		if (new_value) {
			if (strcmp(sym_type,"long")==0) {
				*((long *)sym_adr)=atol(new_value);
			} else if (strcmp(sym_type,"float")==0) {
				*((float *)sym_adr)=atof(new_value);
			} else if (strcmp(sym_type,"string")==0) {
				strncpy((char *)sym_adr,new_value,256);
			}
		}
	
	}
	
//	printf("so symbols ok.\n");

}




void filter(float *srcbuf,float *dstbuf,float *coeff,long num,long bsize) {
	float res;
	long i,j;
	for (i=0;i<num;i++) {
//		res=0.0;
//		for (j=-bsize;j<bsize;j++) res=res - (srcbuf[i+j] * coeff[j+5]);
//		dstbuf[i]=res;
		dstbuf[i]=-srcbuf[i] + srcbuf[i+1];
	}

/* pass 2 */
	for (i=0;i<num;i++) {
//		res=0.0;
//		for (j=-bsize;j<bsize;j++) res=res - (srcbuf[i+j] * coeff[j+5]);
//		dstbuf[i]=res;
//		dstbuf[i]=-srcbuf[i] + srcbuf[i+1];
		if ((dstbuf[i]<0.0) && (dstbuf[i+1]>0.0)) {
			dstbuf[i]=fabs(dstbuf[i]-dstbuf[i+1]);
		} else dstbuf[i]=0.0;
	}
	
	dstbuf[num-1]=0.0;
	dstbuf[num-2]=0.0;

}


void normalize(float *buf,long num) {
	long i;
	float highest_value=-9999.0;
	float lowest_value=9999.0;
	long lowest_index=-1;
	float diff_low_high;
	float height=(float)img_h/2.0;

	/* determine highest and lowest values */
	for (i=0;i<num;i++) {
		if (buf[i]>highest_value) highest_value=buf[i];
		if (buf[i]<lowest_value) {
			lowest_value=buf[i];
			lowest_index=i;
		}
	}
	
	diff_low_high=highest_value-lowest_value;
	
	/* normalize values */
	if (diff_low_high>0) {
		for (i=0;i<num;i++) {
			buf[i]=height*(buf[i]-lowest_value)/diff_low_high;
		}
	}
}


long get_highest(float *buf,long num) {
	long i,result;
	float val=-999999.0;
	for (i=0;i<num;i++) if (buf[i]>val) {val=buf[i];result=i;}
	return result;
}



long get_lowest(float *buf,long num) {
	long i,result;
	float val=999999.0;
	for (i=0;i<num;i++) if (buf[i]<val) {val=buf[i];result=i;}
	return result;
}


float sim_dummy[10];
float sim_values[1000];
float sim_grad[1000];
float sim_lokmin[1000];


float coeff[11]={1.0, 1.0, 1.0, 1.0, 1.0, -6.0, 1.0, 1.0, 1.0, 1.0, 1.0};


draw_similarity_diagram() {
	float (*Get_Similarity) (long *left, long *right, long w);
	long *l,*r;
	long i;
	long lowest_sindex=-1;
	long lowest_gindex=-1;
	long best_lokmin;
	float offset=(float)img_h/4.0;

	Get_Similarity = dlsym(depth_so,"Get_Similarity");
	if (!Get_Similarity) {
		printf("Get_Similarity not defined in this module.\n");
		return;
	}
	check_dlerror("Get_Similarity");

	l=(long *)view_l_img->pixels + img_w*cursor_y;
	r=(long *)view_r_img->pixels + img_w*cursor_y + cursor_x;
	
	/* evaluate similarities */
	for (i=0;i<img_w;i++) {
		sim_values[i]=(*Get_Similarity)(l++,r,img_w);
	}

	filter(sim_values,sim_lokmin,coeff,img_w,3);
	normalize(sim_values,img_w);
	normalize(sim_lokmin,img_w);
	
	lowest_sindex=get_lowest(sim_values,img_w);
	best_lokmin=get_highest(sim_lokmin,img_w);
	
	/* display values */
	for (i=0;i<img_w;i++) {
		
		glBegin(GL_LINES);
		glColor3f(0.9,0.0,0.0);
		glVertex2f(i+img_w,sim_lokmin[i]+img_h+offset*2);
		glVertex2f(i+img_w,img_h+offset*2);
		glEnd();
		
		glBegin(GL_POINTS);
		glColor3f(0.0,0.9,0.0);
		glVertex2f(i+img_w,sim_values[i]+img_h);
		glEnd();
	}

	/* draw best lokmin */
	glBegin(GL_LINES);
	glColor3f(0.9,0.5,0.5);
	glVertex2f(best_lokmin+img_w,sim_lokmin[best_lokmin]+img_h+offset*2);
	glVertex2f(best_lokmin+img_w,img_h+offset*2);
	glEnd();

	/* mark best similarity */
	glPointSize(3.0);
	glEnable(GL_POINT_SMOOTH);
	glBegin(GL_POINTS);
	glColor3f(0.9,0.9,0.9);
	glVertex2f(lowest_sindex+img_w,sim_values[lowest_sindex]+img_h);
	glEnd();
	glPointSize(1.0);
	glDisable(GL_POINT_SMOOTH);
	
}










/******************************
 *                            
 * GLUT CALLBACK
 *
 ******************************/


void redraw(void) {
	float (*Get_Disparity) (long x, long y);
	float disparity;

    glClear(GL_COLOR_BUFFER_BIT);

	if (depth_initflag) {
		update_so_vars(depth_so);
	}

	if (view_l_img) {
		glRasterPos2i(img_w,0);
		glDrawPixels(view_l_img->w,view_l_img->h,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid *)view_l_img->pixels);
	}
	
	if (view_r_img) {
		glRasterPos2i(0,0);
		glDrawPixels(view_r_img->w,view_r_img->h,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid *)view_r_img->pixels);
	}
	
	if (view_d_img) {
		glRasterPos2i(0,img_h);
		glDrawPixels(view_d_img->w,view_d_img->h,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid *)view_d_img->pixels);
	}
	
	
	/* cursor in left picture */
	glColor3f(0.5,0.3,0.8);
	glBegin(GL_LINES);
	glVertex2i(0,cursor_y);
	glVertex2i(2*img_w,cursor_y);
	glVertex2i(cursor_x,0);
	glVertex2i(cursor_x,img_h);
	glEnd();

	/* cursor in diagram */
	glBegin(GL_LINES);
	glVertex2i(cursor_x+img_w,img_h*2);
	glVertex2i(cursor_x+img_w,img_h);
	glEnd();
	

	/* draw result of module */
	Get_Disparity = dlsym(depth_so,"Get_Disparity");
	if (Get_Disparity) {
	
		disparity=(*Get_Disparity)(cursor_x,cursor_y);
		glColor3f(0.9,0.9,0.0);
		glBegin(GL_LINES);
		glVertex2i(cursor_x+disparity+img_w,img_h*2);
		glVertex2i(cursor_x+disparity+img_w,0);
		glEnd();
	
	} else {
		printf("redraw: Get_Disparity not defined in this module.\n");	
	}

	/* draw diagram */
	draw_similarity_diagram();
	
	
	glutSwapBuffers();
}


void motion(int x, int y) {
	y=2*img_h-y;
	if ((x<img_w) && (y<img_h)) {
		cursor_x=x;cursor_y=y;
		glutPostRedisplay();
	}
}


void reshape(int w, int h) {
	glViewport (0, 0, w, h);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluOrtho2D(0, w, 0, h);
}

/* flags for thread synchonisation */
long glut_done=0;
long glut_goon=1;
long glut_halted=0;

long gl_ready=0;
void idle(void) {
	static long old_img_w, old_img_h;
    gl_ready=1;
	glutSetWindow(depth_win_id);
	if ((old_img_w!=img_w) || (old_img_h!=img_h)) glutReshapeWindow(2*img_w,2*img_h);
	old_img_w=img_w;
	old_img_h=img_h;
	glut_done=1;
	if (!glut_goon) {
		printf("glutthread: ohh... I will wait.\n");
		glut_halted=1;
	}
	while (!glut_goon) {glut_halted=1;};
	glut_halted=0;
}




void SyncGlutThread(void) {

		if (glut_halted) {
			printf("glutthreadsync: leaving because thread is halted already.\n");
			return;
		} else {
			printf("glutthreadsync: waiting...\n");
		}
		/* force the thread to halt after the current computation */
		glut_goon=0;
		/* wait until the thread finished the current computation */
		glut_done=0;
		while (!glut_done);
		printf("glutthreadsync: glutthread is ready.");
}


void ContinueGlutThread(void) {
		/* tell the learning thread to go on */
		printf("continueglutthread.\n");
		glut_goon=1;
}





/* arguments: <command name> */
int TCL_InitDepthEval(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	void (*Init_DepthEval) (void);
	void (*Deinit_DepthEval) (void);

	printf("depth_init: get adresses of module functions...\n");				
	
	Init_DepthEval = dlsym(depth_so,"Init_DepthEval");
	check_dlerror("Init_DepthEval");

	Deinit_DepthEval = dlsym(depth_so,"Deinit_DepthEval");
	check_dlerror("Deinit_DepthEval");
				
	printf("depth_init: update shared variables...\n");				
	update_so_vars(depth_so);

	SyncGlutThread();
				
	if (Deinit_DepthEval) (*Deinit_DepthEval)();

	printf("depth_init: init...\n");				
	if (Init_DepthEval) {
	printf("depth_init: InitDepthEval...\n");				
		(*Init_DepthEval)();
	printf("depth_init: InitDepthEval finished.\n");				
		depth_initflag=1;
	}

	/* load left and right image for visualisation */
	printf("depth_init: load images for display...\n");				
	view_l_img=Load_RGB_Image(Tcl_GetVar(interp,"dep_left_img_fname",0),IMAGE_RGBA_CHAR);
	view_r_img=Load_RGB_Image(Tcl_GetVar(interp,"dep_right_img_fname",0),IMAGE_RGBA_CHAR);

	
	if ((view_l_img) && (view_r_img)) {
		img_w=view_l_img->w;
		img_h=view_l_img->h;
	printf("depth_init: post redisplay...\n");				
	} else {
		img_w=50;
		img_h=50;
		view_l_img=(void *)0;
		view_r_img=(void *)0;
	}


	calc_d_img=Create_Image(img_w,img_h,IMAGE_GRAY_FLOAT);
	view_d_img=Create_Image(img_w,img_h,IMAGE_RGBA_CHAR);
	
	printf("depth_init: ok\n");				
	
		
		
	ContinueGlutThread();
	//glutPostRedisplay();

	/* update visualisation */
//	while (visupdate_flag);
//	visupdate_flag=1;

	
	return TCL_OK;
}



/*** SET THE SHARED OBJECT TO USE ***
 * usage: SetModule <module type> <handle of shared object>
 */
int TCL_SetModule(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {

	if (!strcmp(argv[1],"depth")) {
		depth_so = atop(argv[2]);
		depth_initflag=0;
	}
	return TCL_OK;
}



void normalize_image(image *img) {
	long numpix=img->w*img->h;
	long i;
	float *pix=img->pixels;
	float min=99999.0,max=-99999.0;

	/* find min and max */
	for (i=0;i<numpix;i++) {
		if (*pix>max) max=*pix;
		if (*pix<min) min=*pix;
		pix++;
	}
	
	/* normalize */
	for (i=0;i<numpix;i++) {
		*pix=255.0*(*pix-min)/(max-min);
		pix++;
	}
}



long map_thread_state=-1;
long map_thread_up=0;
long map_thread_exit=0;
pthread_t cm_thread;
void *calc_map_thread(void *arg) {
	long x,y;
	float (*Get_Disparity) (long x, long y);
	float *dst;

	map_thread_up=1;
	map_thread_exit=0;

	Get_Disparity = dlsym(depth_so,"Get_Disparity");
	
	y=0;
	while ((!map_thread_exit) && (y<img_h)) {
		for (x=0;x<img_w;x++) {
			dst=(float *)calc_d_img->pixels + img_w*y + x;
			*dst=(*Get_Disparity)(x,y);
			if (*dst<0.0) *dst=0.0;
		}
		map_thread_state=(y*100)/img_h;
		y++;	
	}
	map_thread_up=0;
	map_thread_state=-1;
	
	normalize_image(calc_d_img);	
	Image_float2rgba(calc_d_img,view_d_img);
	glutPostRedisplay();
}


int TCL_StartMapCalculation(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	if (!map_thread_up) {
		pthread_create(&cm_thread,NULL,&calc_map_thread,NULL);
	}
	map_thread_state=0;
	return TCL_OK;
}

int TCL_StopMapCalculation(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	map_thread_exit=1;
	while (map_thread_up);
	return TCL_OK;
}

int TCL_GetMapCalcState(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	interp->result=ltoa(map_thread_state,TCL_result);
	return TCL_OK;
}

/******************************
 *                            
 * HANDLING OF SHARED OBJECTS
 *
 ******************************/
 


/*** OPENS A SHARED OBJECT FILE ***
 * usage:   dlOpen <filename of shared object>
 * returns: handle of this shared object
 */
int TCL_dlOpen(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	void *so_handle;
	if (argc==2) {
		so_handle=dlopen(argv[1],RTLD_LAZY);
		check_dlerror("dlopen");
		interp->result=ptoa(so_handle,(char *)&TCL_result);
	}
	return TCL_OK;
}


/*** CLOSES A SHARED OBJECT FILE ***
 * usage: dlClose <handle of shared object>
 */
int TCL_dlClose(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	if (argc==2) dlclose(atop(argv[1]));
	check_dlerror("dlclose");
	return TCL_OK;
}


/*** RETURNS A STRING WHICH IS DEFINED INSIDE A SHARED OBJECT ***
 * usage:   dlGetString <handle of shared object> <identifier>
 * returns: corresponding identifier or the error message "not defined"
 */
int TCL_dlGetString(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	char **so_string;
	void *so_handle = atop(argv[1]);
	if (argc==3) {
		so_string=(char **)dlsym(so_handle,argv[2]);
		if (dlerror()) {
			interp->result="not defined";
		} else {
			interp->result=*so_string;
		}
	}
	return TCL_OK;
}


///*** SET VALUE OF A SPECIFIED MEMORY LOCATION - INSPIRED BY A BASIC COMMAND :-) ***
// * arguments: dlPoke <pointer> <type> <value>
// */
//int TCL_dlPoke(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
//	if (argc==4) {
//		if (!strcmp(argv[2],"long")) {
//			*((long *)atop(argv[1]))=atol(argv[3]);
//			return TCL_OK;	
//		}
//		if (!strcmp(argv[2],"float")) {
//			*((float *)atop(argv[1]))=atof(argv[3]);
//			return TCL_OK;	
//		}
//		if (!strcmp(argv[2],"string")) {
//			strncpy((char *)atop(argv[1]),argv[3],256);
//			return TCL_OK;	
//		}
//	}
//	return TCL_OK;
//}


/*** GETS VALUE OF A SPECIFIED MEMORY LOCATION ***
 * arguments: dlPeek <pointer> <type>
 * returns:   value of the specified variable
 */
int TCL_dlPeek(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	if (argc==3) {
		if (!strcmp(argv[2],"long")) {
			interp->result=ltoa(*((long *)atop(argv[1])),TCL_result);
			return TCL_OK;
		}
		if (!strcmp(argv[2],"float")) {
			interp->result=ftoa(*((float *)atop(argv[1])),TCL_result);
			return TCL_OK;
		}
		if (!strcmp(argv[2],"string")) {
			strncpy(TCL_result,(char *)atop(argv[1]),256);
/*			interp->result=ftoa(*((float *)atop(argv[1])),TCL_result);*/
			return TCL_OK;
		}
	}
	return TCL_OK;
}


/*** RETURNS ADRESS OF A SYMBOL OF A SHARED OBJECT ***
 * arguments: dlGetAdress <handle of shared object> <symbol>
 * returns:   adress of the specified symbol in shared object
 */
int TCL_dlGetAdress(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {
	void *sym_adr;
	void *so_handle = atop(argv[1]);
	if (argc==3) {
		sym_adr=dlsym(so_handle,argv[2]);
		if (dlerror()) {
			interp->result="not defined";
		} else {
			interp->result=ptoa(sym_adr,TCL_result);
		}
	}
	return TCL_OK;
}


int Tcl_AppInit(Tcl_Interp *interpreter) {

	interp=interpreter;

	if (Tcl_Init(interp) == TCL_ERROR) return TCL_ERROR;
	Tk_Init(interp);	

	
	Tcl_CreateCommand(interp,"SetModule",TCL_SetModule,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);

	Tcl_CreateCommand(interp,"InitDepthEval",TCL_InitDepthEval,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);


	Tcl_CreateCommand(interp,"StartMapCalculation",TCL_StartMapCalculation,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp,"StopMapCalculation",TCL_StopMapCalculation,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp,"GetMapCalcState",TCL_GetMapCalcState,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);

	/* provide tcl commands to access to shared object files */
	Tcl_CreateCommand(interp,"dlOpen",TCL_dlOpen,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp,"dlClose",TCL_dlClose,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp,"dlGetString",TCL_dlGetString,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp,"dlGetAdress",TCL_dlGetAdress,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp,"dlPeek",TCL_dlPeek,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
//	Tcl_CreateCommand(interp,"dlPoke",TCL_dlPoke,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);

	Tcl_SetVar(interp, "tcl_rcFileName", "twin.tcl",TCL_GLOBAL_ONLY);
	return TCL_OK;
}








/*** OPENGL GLUT THREAD ***/
pthread_t gl_thread;
int glut_argc=1;
char *glut_arg1="dummyname";
char **glut_args=&glut_arg1;

void *do_glut_mainloop(void *arg) {

	glutInit(&glut_argc,glut_args);

	glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
	glutInitWindowSize(200,100);
	depth_win_id=glutCreateWindow("Depth Evaluation Test");
	glutDisplayFunc(redraw);
	glutIdleFunc(idle);
	glutReshapeFunc(reshape);	
	glutPassiveMotionFunc(motion);

	glShadeModel (GL_FLAT);

    glEnable(GL_ALPHA_TEST);
    glDisable(GL_BLEND);
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_DITHER);
    glDisable(GL_FOG);
    glDisable(GL_LIGHTING);
    glDisable(GL_LOGIC_OP);
    glDisable(GL_STENCIL_TEST);
    glDisable(GL_TEXTURE_1D);
    glDisable(GL_TEXTURE_2D);

    glPixelTransferi(GL_MAP_COLOR, GL_FALSE);
    glPixelTransferi(GL_RED_SCALE, 1);
    glPixelTransferi(GL_RED_BIAS, 0);
    glPixelTransferi(GL_GREEN_SCALE, 1);
    glPixelTransferi(GL_GREEN_BIAS, 0);
    glPixelTransferi(GL_BLUE_SCALE, 1);
    glPixelTransferi(GL_BLUE_BIAS, 0);
    glPixelTransferi(GL_ALPHA_SCALE, 1);
    glPixelTransferi(GL_ALPHA_BIAS, 0);

	glutMainLoop();
	return NULL;
}



int main(int argc, char **argv) {
	int log_fh;
	char *prgname="Twin";
	char *tclargv[1]={prgname};

	if (argc==1) {
		log_fh=open("twin.log",O_CREAT+O_WRONLY,S_IREAD+S_IWRITE);
		close(1);
		dup2(log_fh,1);
		close(log_fh);
	}

	pthread_create(&gl_thread,NULL,&do_glut_mainloop,NULL);
	while (!gl_ready);

	Tk_Main(1, tclargv, Tcl_AppInit);
	return 0;
}



