/***
 * BLOCKMATCHING DEPTH EVALUATOR
 * by Norman Feske
 ***/

#include <stdio.h>
#include <image.h>
#include <math.h>


/*** LIST OF PUBLIC VARIABLES ***/
char *tcl_symbols = "string dep_left_img_fname, string dep_right_img_fname,\
                     long bm_sizex, long bm_sizey, long disp_min, long disp_max";
char *title = "Shirai Based Matching";


char dep_left_img_fname[256];
char dep_right_img_fname[256];

long bm_sizex=3;
long bm_sizey=3;

long disp_min=0;
long disp_max=400;

image *left_img=(void *)0;
image *right_img=(void *)0;

void Init_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img =Load_RGB_Image(dep_left_img_fname, IMAGE_RGBA_CHAR);
	right_img=Load_RGB_Image(dep_right_img_fname,IMAGE_RGBA_CHAR);
}



void Deinit_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img=(void *)0;
	right_img=(void *)0;
}



/*** RETURNS A VALUE OF SIMILARITY BETWEEN TWO PIXEL BLOCKS ***
 * arguments: left, right are pointers to rgba pixelblocks inside a picture
 */
float red_sim,green_sim,blue_sim;
float Get_Similarity(long *left, long *right, long w) {

	static char *l,*r;
	static long i,j;
	static float result;
	static float red_diff,green_diff,blue_diff;
	static float red_aver,green_aver,blue_aver;
	static float red_vari,green_vari,blue_vari;
	float num_blockpixels=(2*bm_sizex+1)*(2*bm_sizey+1);
	
	/* calculate average values for left block */
	red_aver=green_aver=blue_aver=0;
	for (j=-bm_sizey;j<bm_sizey;j++) {
		for (i=-bm_sizex;i<bm_sizex;i++) {
			l=(char *)(left  + (long)w*j + i);
			red_aver=*(l++);
			green_aver=*(l++);
			blue_aver=*(l++);
		}
	}
	red_aver=red_aver/num_blockpixels;
	green_aver=green_aver/num_blockpixels;
	blue_aver=blue_aver/num_blockpixels;

	red_vari=green_vari=blue_vari=0;	
	red_sim=green_sim=blue_sim=0;
	for (j=-bm_sizey;j<bm_sizey;j++) {
		for (i=-bm_sizex;i<bm_sizex;i++) {
			l=(char *)(left  + (long)w*j + i);
			r=(char *)(right + (long)w*j + i);
		
			red_vari  += pow(*l - red_aver,2);
			red_diff   = (*(r++) - *(l++));
			green_vari+= pow(*l - green_aver,2);
			green_diff = (*(r++) - *(l++));
			blue_vari += pow(*l - blue_aver,2);
			blue_diff  = (*(r++) - *(l++));

			red_sim += red_diff*red_diff;
			green_sim += green_diff*green_diff;
			blue_sim += blue_diff*blue_diff;
		}
	}
	red_vari=red_vari/num_blockpixels;
	green_vari=green_vari/num_blockpixels;
	blue_vari=blue_vari/num_blockpixels;
	
	if ((red_vari==0.0) || (green_vari==0.0) || (blue_vari==0.0)) return -1.0;
	red_sim=red_sim/red_vari;
	green_sim=green_sim/green_vari;
	blue_sim=blue_sim/blue_vari;
	result = red_sim + green_sim + blue_sim;
	return result;
}



float blk_sim[1000];


float Get_Disparity(long x,long y) {
	static long *l,*r;
	long img_w;
	long img_h;
	static long xbeg;
	static long xend;
	float lowest_sim=100000.0;
	float lowest_grad=100000.0;
	long lowest_x=0;
	long lowest_xg=0;
	static long i;
		
	if (!left_img) return -1;
	if (!right_img) return -1;

	img_w=right_img->w;
	img_h=right_img->h;

	if ((y<=bm_sizey) || (y>=img_h-bm_sizey)) return -1;
	if ((x<=bm_sizex) || (x>=img_w-bm_sizex)) return -1;

	xbeg=x+disp_min;
	xend=x+disp_max;
	
	if (xbeg<0) xbeg=0;
	if (xend>img_w) xend=img_w;

	l=(long *)left_img->pixels + (long)img_w*y;
	r=(long *)right_img->pixels + (long)img_w*y + x;

	/* calculate similarities for the pixels at the line y */
	for (i=0;i<img_w;i++) {
		blk_sim[i]=Get_Similarity(l++,r,img_w);		
	}
	
	/* find best value */
	for (i=xbeg;i<xend;i++) {
		if (blk_sim[i]<lowest_sim) {
			lowest_sim=blk_sim[i];
			lowest_x=i;
		}			
	}
	
	return (float)(lowest_x - x);
}

