

# BUILD DIALOG FOR THE BLOCKMATCHING PARAMETERS
proc DepthEval_Dialog {root} {

	grid [label $root.sll -text "Left Image:"] -row 0 -column 0 -sticky e
	grid [entry $root.sli -textvariable dep_left_img_fname -state disabled] -row 0 -column 1 -sticky ew
	bind $root.sli <ButtonRelease-1> "
		set fname \[tk_getOpenFile\]
		if {\$fname!=\"\"} {
			set dep_left_img_fname \$fname
		}
		$root.sli xview end
		InitDepthEval
	"

	grid [label $root.srl -text "Right Image:"] -row 1 -column 0 -sticky e
	grid [entry $root.sri -textvariable dep_right_img_fname -state disabled] -row 1 -column 1 -sticky ew
	bind $root.sri <ButtonRelease-1> "
		set fname \[tk_getOpenFile\]
		if {\$fname!=\"\"} {
			set dep_right_img_fname \$fname
		}
		$root.sri xview end
		InitDepthEval
	"

	grid [label $root.bxl -text "Half Block Width:"] -row 2 -column 0 -sticky e
	grid [scale $root.bx -variable bm_sizex -from 1 -to 5 -orient horizontal] -row 2 -column 1 -sticky ew

	grid [label $root.byl -text "Half Block Height:"] -row 3 -column 0 -sticky e
	grid [scale $root.by -variable bm_sizey -from 1 -to 5 -orient horizontal] -row 3 -column 1 -sticky ew

	grid [label $root.dminl -text "Disparity Min:"] -row 4 -column 0 -sticky e
	grid [scale $root.dmin -variable disp_min -from -500 -to 500 -orient horizontal] -row 4 -column 1 -sticky ew

	grid [label $root.dmaxl -text "Disparity Max:"] -row 5 -column 0 -sticky e
	grid [scale $root.dmax -variable disp_max -from 0 -to 500 -orient horizontal] -row 5 -column 1 -sticky ew

	grid [label $root.rgbml -text "RGB Measure:"] -row 6 -column 0 -sticky e
	grid [radiobutton $root.rgbm1 -variable rgb_measure -value 1 -text "D1"] -row 6 -column 1 -sticky ew
	grid [radiobutton $root.rgbm2 -variable rgb_measure -value 2 -text "D2"] -row 7 -column 1 -sticky ew
	grid [radiobutton $root.rgbm3 -variable rgb_measure -value 3 -text "D3"] -row 8 -column 1 -sticky ew
	grid [radiobutton $root.rgbm4 -variable rgb_measure -value 4 -text "D4"] -row 9 -column 1 -sticky ew
	
	grid columnconfigure $root 1 -weight 1

}



