/***
 * RGB BLOCKMATCHING DEPTH EVALUATOR
 * by Norman Feske
 ***/

#include <image.h>
#include <math.h>


/*** LIST OF PUBLIC VARIABLES ***/
char *tcl_symbols = "string dep_left_img_fname, string dep_right_img_fname,\
                     long bm_sizex, long bm_sizey, long disp_min, long disp_max,\
                     long rgb_measure";
char *title = "RGB-Blockmatching";


char dep_left_img_fname[256];
char dep_right_img_fname[256];

long bm_sizex=3;
long bm_sizey=3;

long disp_min=0;
long disp_max=100;

long rgb_measure=1;

image *left_img=(void *)0;
image *right_img=(void *)0;

void Init_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img =Load_RGB_Image(dep_left_img_fname, IMAGE_RGBA_CHAR);
	right_img=Load_RGB_Image(dep_right_img_fname,IMAGE_RGBA_CHAR);
}



void Deinit_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img=(void *)0;
	right_img=(void *)0;
}



float fmax(float v1,float v2,float v3) {
	float result=v1;
	if (v2>result) result=v2;
	if (v3>result) result=v3;
	return result;
}



/*** RETURNS A VALUE OF SIMILARITY BETWEEN TWO PIXEL BLOCKS ***
 * arguments: left, right are pointers to rgba pixelblocks inside a picture
 */
float red_sim,green_sim,blue_sim;
float Get_Similarity(long *left, long *right, long w) {

	static char *l,*r;
	static long i,j;
	static float result;
	static float red_diff,green_diff,blue_diff;
	static long l_red,l_green,l_blue;
	static long r_red,r_green,r_blue;
	static float l_sum,r_sum;
	static float l_nred,l_ngreen,l_nblue;
	static float r_nred,r_ngreen,r_nblue;
	
	result=0;
	for (j=-bm_sizey;j<bm_sizey;j++) {
		for (i=-bm_sizex;i<bm_sizex;i++) {
			l=(char *)(left  + (long)w*j + i);
			r=(char *)(right + (long)w*j + i);
		
			l_red =   *(l++);
			l_green = *(l++);
			l_blue =  *(l++);
			l_sum = l_red + l_green + l_blue + 0.0000001;
			
			l_nred  =(float)l_red  /l_sum;
			l_ngreen=(float)l_green/l_sum;
			l_nblue =(float)l_blue /l_sum;
			
			r_red =   *(r++);
			r_green = *(r++);
			r_blue =  *(r++);
			r_sum = r_red + r_green + r_blue + 0.0000001;
			
			r_nred  =(float)r_red  /r_sum;
			r_ngreen=(float)r_green/r_sum;
			r_nblue =(float)r_blue /r_sum;
			
			red_diff = l_nred - r_nred;
			green_diff = l_ngreen - r_ngreen;
			blue_diff = l_nblue - r_nblue;
			
			switch (rgb_measure) {
			case 1: result+= sqrt(red_diff*red_diff + green_diff*green_diff + blue_diff*blue_diff);
					break;
			case 2: result+= fabs(red_diff) + fabs(green_diff) + fabs(blue_diff);
					break;
			case 3: result+= fabs(red_diff)*fabs(red_diff) + 
							 fabs(green_diff)*fabs(green_diff) +
							 fabs(blue_diff)*fabs(blue_diff);
					break;
			case 4: result+= fmax(fabs(red_diff),fabs(green_diff),fabs(blue_diff));
					break;
			
			}			
		}
	}
	return result;
}



float blk_sim[1000];


float Get_Disparity(long x,long y) {
	static long *l,*r;
	long img_w;
	long img_h;
	static long xbeg;
	static long xend;
	float lowest_sim=100000.0;
	float lowest_grad=100000.0;
	long lowest_x=0;
	long lowest_xg=0;
	static long i;
		
	if (!left_img) return -1;
	if (!right_img) return -1;
	
	img_w=right_img->w;
	img_h=right_img->h;
	
	if ((y<=bm_sizey) || (y>=img_h-bm_sizey)) return -1;
	if ((x<=bm_sizex) || (x>=img_w-bm_sizex)) return -1;

	xbeg=x+disp_min;
	xend=x+disp_max;
	
	if (xbeg<0) xbeg=0;
	if (xend>img_w) xend=img_w;

	l=(long *)left_img->pixels + (long)img_w*y;
	r=(long *)right_img->pixels + (long)img_w*y + x;

	/* calculate similarities for the pixels at the line y */
	for (i=0;i<img_w;i++) {
		blk_sim[i]=Get_Similarity(l++,r,img_w);		
	}
	
	/* find best value */
	for (i=xbeg;i<xend;i++) {
		if (blk_sim[i]<lowest_sim) {
			lowest_sim=blk_sim[i];
			lowest_x=i;
		}			
	}
	
	return (float)(lowest_x - x);
}

