/***
 * DISPARITY MAP
 * by Norman Feske
 ***/

#include <image.h>
#include <math.h>


/*** LIST OF PUBLIC VARIABLES ***/
char *tcl_symbols = "string dep_map_img_fname, float depmap_scale";
char *title = "Disparity Map";

char dep_map_img_fname[256];
float depmap_scale=0.1;

image *map_img=(void *)0;

void Init_DepthEval() {
	if (map_img) Destroy_Image(map_img);
	map_img =Load_RGB_Image(dep_map_img_fname, IMAGE_GRAY_FLOAT);
}



void Deinit_DepthEval() {
	Destroy_Image(map_img);
}




float Get_Disparity(long x,long y) {
	float *pix;
	long img_w=map_img->w;
	
	if (!map_img) return -1.0;
	pix=(float *)map_img->pixels + img_w*y + x;
	return depmap_scale * (*pix);
}

