/***
 * BLOCKMATCHING DEPTH EVALUATOR
 * by Norman Feske
 ***/

#include <stdio.h>
#include <image.h>
#include <math.h>


/*** LIST OF PUBLIC VARIABLES ***/
char *tcl_symbols = "string dep_left_img_fname, string dep_right_img_fname,\
                     long bm_sizex, long bm_sizey, long disp_min, long disp_max";
char *title = "Best Local Minimum";


char dep_left_img_fname[256];
char dep_right_img_fname[256];

long bm_sizex=3;
long bm_sizey=3;

long disp_min=0;
long disp_max=400;

image *left_img=(void *)0;
image *right_img=(void *)0;

void Init_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img =Load_RGB_Image(dep_left_img_fname, IMAGE_RGBA_CHAR);
	right_img=Load_RGB_Image(dep_right_img_fname,IMAGE_RGBA_CHAR);
}



void Deinit_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img=(void *)0;
	right_img=(void *)0;
}



/*** RETURNS A VALUE OF SIMILARITY BETWEEN TWO PIXEL BLOCKS ***
 * arguments: left, right are pointers to rgba pixelblocks inside a picture
 */
float red_sim,green_sim,blue_sim;
float Get_Similarity(long *left, long *right, long w) {

	static char *l,*r;
	static long i,j;
	static float result;
	static float red_diff,green_diff,blue_diff;
	
	result=0;
	red_sim=0;
	green_sim=0;
	blue_sim=0;
	for (j=-bm_sizey;j<bm_sizey;j++) {
		for (i=-bm_sizex;i<bm_sizex;i++) {
			l=(char *)(left  + (long)w*j + i);
			r=(char *)(right + (long)w*j + i);
		
			red_diff   = (*(r++) - *(l++));
			green_diff = (*(r++) - *(l++));
			blue_diff  = (*(r++) - *(l++));

			red_sim += red_diff*red_diff;
			green_sim += green_diff*green_diff;
			blue_sim += blue_diff*blue_diff;
			result += sqrt (red_diff*red_diff + green_diff*green_diff + blue_diff*blue_diff);		
//			result += red_diff*red_diff + green_diff*green_diff + blue_diff*blue_diff;
		}
	}
	red_sim=sqrt(red_sim);
	green_sim=sqrt(green_sim);
	blue_sim=sqrt(blue_sim);
	result = (red_sim + green_sim + blue_sim)/3;
	return result;
}


/*** FINDS LOCAL MINIMA IN A SPECIFIED BUFFER */
void lokmin_filter(float *srcbuf,float *dstbuf,long num) {
	float res;
	long i,j;
	
	/* calculate gradient */
	for (i=0;i<num;i++) dstbuf[i]=-srcbuf[i] + srcbuf[i+1];
	

	/* find sign changes */
	for (i=0;i<num;i++) {
		if ((dstbuf[i]<0.0) && (dstbuf[i+1]>0.0)) dstbuf[i]=fabs(dstbuf[i]-dstbuf[i+1]);
		else dstbuf[i]=0.0;
	}
	
	/* fix last values (where the gradient is not defined) */
	dstbuf[num-1]=0.0;
	dstbuf[num-2]=0.0;
	dstbuf[num-3]=0.0;
}


/*** NORMALIZES SPECIFIED BUFFER ***/
void normalize(float *buf,long num) {
	long i;
	float highest_value=-9999.0;
	float lowest_value=9999.0;
	long lowest_index=-1;
	float diff_low_high;
	float height=1.0;

	/* determine highest and lowest values */
	for (i=0;i<num;i++) {
		if (buf[i]>highest_value) highest_value=buf[i];
		if (buf[i]<lowest_value) {
			lowest_value=buf[i];
			lowest_index=i;
		}
	}
	
	diff_low_high=highest_value-lowest_value;
	
	/* normalize values */
	if (diff_low_high>0) {
		for (i=0;i<num;i++) {
			buf[i]=height*(buf[i]-lowest_value)/diff_low_high;
		}
	}
}


void fill_buffer(float *buf,long num,float value) {
	long i;
	for (i=0;i<num;i++) *(buf++)=value;
}


/*** GET INDEX OF THE HIGHEST VALUE OF A BUFFER ***/
long get_highest(float *buf,long num) {
	long i,result=0;
	float val=-999999.0;
	for (i=0;i<num;i++) if (buf[i]>val) {val=buf[i];result=i;}
	return result;
}


/*** GET INDEX OF THE LOWEST VALUE OF A BUFFER ***/
long get_lowest(float *buf,long num) {
	long i,result=0;
	float val=999999.0;
	for (i=0;i<num;i++) if (buf[i]<val) {val=buf[i];result=i;}
	return result;
}


float blk_sim[1000];
float blk_lokmin[1000];

float Get_Disparity(long x,long y) {
	static long *l,*r;
	long img_w;
	long img_h;
	static long xbeg;
	static long xend;
	float lowest_sim=100000.0;
//	float lowest_grad=100000.0;
	long lowest_x=0;
//	long lowest_xg=0;
	long best_lokmin_x;
	float sim;
	static long i;
	
	long value_found;
		
	if (!left_img) return -1;
	if (!right_img) return -1;

	img_w=right_img->w;
	img_h=right_img->h;

	if ((y<=bm_sizey) || (y>=img_h-bm_sizey)) return -1;
	if ((x<=bm_sizex) || (x>=img_w-bm_sizex)) return -1;

	xbeg=x+disp_min;
	xend=x+disp_max;
	
	if (xbeg<0) xbeg=0;
	if (xend>img_w) xend=img_w;

	l=(long *)left_img->pixels + (long)img_w*y;
	r=(long *)right_img->pixels + (long)img_w*y + x;

	/* calculate similarities for the pixels at the line y */
	for (i=0;i<img_w;i++) {
		blk_sim[i]=Get_Similarity(l++,r,img_w);		
	}
	
	normalize(blk_sim,img_w);
	
	/* find local minima */
	lokmin_filter(blk_sim,blk_lokmin,img_w);

	normalize(blk_lokmin,img_w);
	
	/* blend out values outside the displarity limit */
	fill_buffer(blk_lokmin,xbeg-1,0.0);
	fill_buffer(blk_lokmin+xend,img_w-xend,0.0);

	fill_buffer(blk_sim,xbeg-1,10000.0);
	fill_buffer(blk_sim+xend,img_w-xend,10000.0);
	
	/* find best value */
	/*
	value_found=0;
	for (i=0;(i<7) && (!value_found);i++) {
		best_lokmin_x=get_highest(blk_lokmin,img_w);
		if (blk_sim[best_lokmin_x]<0.4) value_found=1;
		else blk_lokmin[best_lokmin_x]=0.0;
	};
	*/
	
	/*
	lowest_x=xend;
	for (i=0;i<3;i++) {
		best_lokmin_x=get_highest(blk_lokmin,img_w);
		
		sim=blk_sim[best_lokmin_x];
		if (sim<lowest_sim)) {
			lowest_sim=sim;
			lowest_x=best_lokmin_x;
		}
		blk_lokmin[best_lokmin_x]=0.0;
	}
	*/
	
/*	
	lowest_x=get_highest(blk_lokmin,img_w);
	if (blk_lokmin[lowest_x]>0.0) {
		blk_lokmin[lowest_x]=0.0;
		for (i=0;i<3;i++) {
			best_lokmin_x=get_highest(blk_lokmin,img_w);
			
			if ((best_lokmin_x<lowest_x) && (blk_sim[best_lokmin_x]<blk_sim[lowest_x])) {
				if (blk_lokmin[best_lokmin_x]>0.0) lowest_x=best_lokmin_x;
			}
			blk_lokmin[best_lokmin_x]=0.0;
		}
	} else return 0.0;
	*/
	

	best_lokmin_x=get_highest(blk_lokmin,img_w);
	/*
	lowest_x=get_lowest(blk_sim,img_w);
	
	if (abs(best_lokmin_x-lowest_x)<3) return (best_lokmin_x - x);
	else return 0.0;
	*/
	return (float)(best_lokmin_x - x);
//	return (float)(lowest_x - x);
}

