/* ---- memory allocation ---- */


#include <stdlib.h>
#include <stdio.h>


int *alloc_1d_int(int n1);
void free_1d_int(int *i);
double *alloc_1d_double(int n1);
void free_1d_double(double *d);
int **alloc_2d_int(int n1, int n2);
void free_2d_int(int **ii);
double **alloc_2d_double(int n1, int n2);
void free_2d_double(double **dd);


int *alloc_1d_int(int n1)
{
    int *i;
    
    i = (int *) malloc(n1 * sizeof(int));
    if (i == NULL) {
        printf("Allocation Failure!\n");
        exit(1);
    }
    return i;
}


void free_1d_int(int *i)
{
    free(i);
}


double *alloc_1d_double(int n1)
{
    double *d;
    
    d = (double *) malloc(n1 * sizeof(double));
    if (d == NULL) {
        printf("Allocation Failure!\n");
        exit(1);
    }
    return d;
}


void free_1d_double(double *d)
{
    free(d);
}


int **alloc_2d_int(int n1, int n2)
{
    int **ii, *i;
    int j;
    
    ii = (int **) malloc(n1 * sizeof(int *));
    if (ii == NULL) {
        printf("Allocation Failure!\n");
        exit(1);
    }
    i = (int *) malloc(n1 * n2 * sizeof(int));
    if (i == NULL) {
        printf("Allocation Failure!\n");
        exit(1);
    }
    ii[0] = i;
    for (j = 1; j < n1; j++) {
        ii[j] = &i[n2 * j];
    }
    return ii;
}


void free_2d_int(int **ii)
{
    free(ii[0]);
    free(ii);
}


double **alloc_2d_double(int n1, int n2)
{
    double **dd, *d;
    int j;
    
    dd = (double **) malloc(n1 * sizeof(double *));
    if (dd == NULL) {
        printf("Allocation Failure!\n");
        exit(1);
    }
    d = (double *) malloc(n1 * n2 * sizeof(double));
    if (d == NULL) {
        printf("Allocation Failure!\n");
        exit(1);
    }
    dd[0] = d;
    for (j = 1; j < n1; j++) {
        dd[j] = &d[n2 * j];
    }
    return dd;
}


void free_2d_double(double **dd)
{
    free(dd[0]);
    free(dd);
}

