/***
 * BLOCKMATCHING DEPTH EVALUATOR
 * by Norman Feske
 ***/

#include <stdio.h>
#include <image.h>
#include <math.h>


/*** LIST OF PUBLIC VARIABLES ***/
char *tcl_symbols = "string dep_left_img_fname, string dep_right_img_fname,\
                     long bm_sizex, long bm_sizey, long disp_min, long disp_max";
char *title = "Cross Correlation";

char dep_left_img_fname[256];
char dep_right_img_fname[256];

long bm_sizex=3;
long bm_sizey=3;

long disp_min=0;
long disp_max=400;

image *left_img=(void *)0;
image *right_img=(void *)0;

void Init_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img =Load_RGB_Image(dep_left_img_fname, IMAGE_RGBA_CHAR);
	right_img=Load_RGB_Image(dep_right_img_fname,IMAGE_RGBA_CHAR);
}


void Deinit_DepthEval() {
	if (left_img) Destroy_Image(left_img);
	if (right_img) Destroy_Image(right_img);
	left_img=(void *)0;
	right_img=(void *)0;
}



/*** RETURNS A VALUE OF SIMILARITY BETWEEN TWO PIXEL BLOCKS ***
 * arguments: left, right are pointers to rgba pixelblocks inside a picture
 */
float red_sim,green_sim,blue_sim;
float Get_Similarity(long *left, long *right, long w) {

	static char *l,*r;
	static long i,j;
	static float result;
	static float red_diff,green_diff,blue_diff;
	static float red_prod,green_prod,blue_prod;
	static float red_lsqsum,green_lsqsum,blue_lsqsum;
	static float red_rsqsum,green_rsqsum,blue_rsqsum;

	red_lsqsum=green_lsqsum=blue_lsqsum=0;
	red_rsqsum=green_rsqsum=blue_rsqsum=0;
	red_prod=green_prod=blue_prod=0;
	
	for (j=-bm_sizey;j<bm_sizey;j++) {
		for (i=-bm_sizex;i<bm_sizex;i++) {
			l=(char *)(left  + (long)w*j + i);
			r=(char *)(right + (long)w*j + i);

			red_lsqsum+=(*l)*(*l);
			red_rsqsum+=(*r)*(*r);
			red_prod+=*(r++) * *(l++);

			green_lsqsum+=(*l)*(*l);
			green_rsqsum+=(*r)*(*r);
			green_prod+=*(r++) * *(l++);

			blue_lsqsum+=(*l)*(*l);
			blue_rsqsum+=(*r)*(*r);
			blue_prod+=*(r++) * *(l++);
		}
	}
	
	red_sim=red_prod/(sqrt(red_lsqsum)*sqrt(red_rsqsum));
	green_sim=green_prod/(sqrt(green_lsqsum)*sqrt(green_rsqsum));
	blue_sim=blue_prod/(sqrt(blue_lsqsum)*sqrt(blue_rsqsum));
	
	result=-(red_sim + green_sim + blue_sim);
	return result;
}



float blk_sim[1000];


float Get_Disparity(long x,long y) {
	static long *l,*r;
	long img_w;
	long img_h;
	static long xbeg;
	static long xend;
	float lowest_sim=100000.0;
	float lowest_grad=100000.0;
	long lowest_x=0;
	long lowest_xg=0;
	static long i;
		
	if (!left_img) return -1;
	if (!right_img) return -1;

	img_w=right_img->w;
	img_h=right_img->h;

	if ((y<=bm_sizey) || (y>=img_h-bm_sizey)) return -1;
	if ((x<=bm_sizex) || (x>=img_w-bm_sizex)) return -1;

	xbeg=x+disp_min;
	xend=x+disp_max;
	
	if (xbeg<0) xbeg=0;
	if (xend>img_w) xend=img_w;

	l=(long *)left_img->pixels + (long)img_w*y;
	r=(long *)right_img->pixels + (long)img_w*y + x;

	/* calculate similarities for the pixels at the line y */
	for (i=0;i<img_w;i++) {
		blk_sim[i]=Get_Similarity(l++,r,img_w);		
	}
	
	/* find best value */
	for (i=xbeg;i<xend;i++) {
		if (blk_sim[i]<lowest_sim) {
			lowest_sim=blk_sim[i];
			lowest_x=i;
		}			
	}
	
	return (float)(lowest_x - x);
}

