#
# SCRIPT TO HANDLE THE CONSOLE WINDOW
#
# This script defines the function 'print' which should be used to
# print status information. The printed text will appear in a console
# window. All printed text is buffered. So closing and opening the
# console window does not kill the text.
#


# flag to indicate the status of the console window (1 = open)
set console_flag 0

# text buffer (a list) Each listentry contains one textline + colorflag
set console_text {}


#=- FUNCTION TO PRINT TEXT TO THE CONSOLE -=#
proc print {string} {
	global console_flag
	global console_text
	set col col1
	if {[string match "  *"     $string]} {set col col2}
	if {[string match "    *"   $string]} {set col col3}
	if {[string match "      *" $string]} {set col col4}
	if {$console_flag} {
		.console.top.text insert end "$string\n" $col
		.console.top.text see end
	}
	lappend console_text [list "$string\n" $col]
}


#=- OPEN THE CONSOLE WINDOW (ONLY WHEN IT IS NOT ALREADY OPEN) -=#
proc open_console {} {
	global console_flag
	global console_text

	if {!$console_flag} {
	
		# create console window and its widgets
		toplevel 	.console
  		frame 		.console.bf
		button 		.console.bf.close 	-text Close 
		button 		.console.bf.clear 	-text Clear 
		frame 		.console.top
		scrollbar 	.console.top.vsb 	-orient vertical -command [list .console.top.text yview]
		scrollbar 	.console.top.hsb 	-orient horizontal -command [list .console.top.text xview]
		text 		.console.top.text 	-yscrollcommand [list .console.top.vsb set] \
										-xscrollcommand [list .console.top.hsb set] \
							   			-bg black -width 50 -height 16 -wrap none
		# define button commands
		.console.bf.close configure -command {
			destroy .console
			set console_flag 0
		}
		.console.bf.clear configure -command {
			.console.top.text delete 1.0 end
			set console_text {}
		}
							   
		# fill console with old text
		foreach line $console_text {
			.console.top.text insert end [lindex $line 0] [lindex $line 1]
		}
		.console.top.text see end
		
		# configure color tags
		foreach e [list {col1 #ffffff} {col2 #aaccff} {col3 #7799dd} {col4 #5577bb}] {
			.console.top.text tag configure [lindex $e 0] -foreground [lindex $e 1]
		}
		
		# make widgets visible
		grid .console.top.text -row 0 -column 0 -sticky nsew
		grid .console.top.vsb -row 0 -column 1 -sticky ns
		grid .console.top.hsb -row 1 -column 0 -sticky ew
  		grid columnconfigure .console.top 0 -weight 1
  		grid rowconfigure .console.top 0 -weight 1
		pack .console.top -expand yes -fill both
		pack .console.bf.close -side right
		pack .console.bf.clear -side right
		pack .console.bf
		set console_flag 1;
	}
}

