/******************************************************************************
 *
 * BEISPIEL-PROGRAMM FR DIE BENUTZUNG VON PTHREADS (OPENGL WINDOW IS A THREAD)
 * NICHT UNBEDINGT DIE SCHNELLSTE VARIANE, ABER ANSCHAULICH
 *
 * Norman Feske, Feb.2002
 *
 ******************************************************************************/


#include <stdlib.h>
#include <dlfcn.h>
#include <unistd.h>
#include <signal.h>
#include <pthread.h>

#include <math.h>
#include <stdio.h>

#include <SDL/SDL.h>


/* Variablen, die sowohl vom Hauptprogramm alsauch vom glut-thread */
/* verwendet werden */
long img_w=200;  /* Gre des Bildes */
long img_h=200;
long *img_buf;   /* Zeiger auf die Pixeldaten zum Darstellen*/
long *calc_buf;  /* Zeiger auf die Pixeldaten zum Berechnen */


/**************************************************************************/
/*** HIER FOLGT DER CODE DES SDL-THREADS.                               ***/
/*** DER SDL-THREAD KMMERT SICH UM DIE VERWALTUNG DES FENSTERS         ***/
/*** NACH DER INITIALISIERUNG WIRD REGELMSSIG EIN FLAG BERPRFT, WAS  ***/
/*** ANZEIGT, OB EIN NEUZEICHNEN DES FENSTERS NOTWENDIG IST.            ***/
/**************************************************************************/

/* Jeder Posix-Thread bentigt ein handle. */
/* ...siehe pthread_create() weiter unten. */
pthread_t sdl_thread_handle;
long sdl_redraw_flag=0;

SDL_Surface *screen;

/*** FUNKTION, DIE BEIM START DES GLUT-THREADS AUFGERUFEN WIRD. ***/
void *sdl_thread(void *arg) {
    SDL_Event event;
	
    if((SDL_Init(SDL_INIT_VIDEO)==-1)) { 
        printf("Could not initialize SDL: %s.\n", SDL_GetError());
        exit(-1);
    }	
    screen = SDL_SetVideoMode(img_w, img_h, 32, SDL_SWSURFACE);
    if ( screen == NULL ) {
        fprintf(stderr, "Couldn't set %lux%lux16 video mode: %s\n",img_w,img_h,
                        SDL_GetError());
        exit(1);
    }	
	
    while (1) {
		if (SDL_PollEvent(&event)) {
	        switch (event.type) {
	            case SDL_QUIT: {
	                printf("Quit requested, quitting.\n");
	                exit(0);
	            }
	            break;
	        }
		}
		
		if (sdl_redraw_flag) {
			long i=img_w*img_h;
			long *src=img_buf;
			long *dst=screen->pixels;
			sdl_redraw_flag=0;
			for (;i--;) *(dst++)=*(src++);
			SDL_UpdateRect(screen,0,0,img_w,img_h);
		}
    }	
	
	return NULL;
}



/**************************************************************************/
/*** EIGENTLICHES HAUPTPROGRAMM                                         ***/
/**************************************************************************/


/*** ZEICHNE ZUFLLIG EIN PAAR PIXEL ***/
void drawcrap(long max_x,long max_y,long num,long *buf) {
	long i,j,x,y;
	long mask=0xff808080;
	for (i=0;i<num;i++) {
		x=random()%max_x;
		y=random()%max_y;
		for (j=5;j--;) {
			*(buf+img_w*y+x+j)=random();
			*(buf+img_w*(y+1)+x+j)=random();
			*(buf+img_w*(y+2)+x+j)=random();
			*(buf+30+img_w*(y+1)+x+j)=0;
		}
	}
}


/*** FUNKTION ZUM 'VERWISCHEN' DES BILDES ***/
/* Entschuldigung, wegen der Klammern... */
void smooth(long w,long h,long *buf) {
	long *src=buf+w*(h-3);
	long *dst=buf+w*(h-1);
	long mask=0xfefefefe;
	long cnt;
	
	for (cnt=w*(h-3);cnt;cnt--) {
		*(dst--)= ((((((*(src+w))&mask)>>1) + (((*(src-w))&mask)>>1))&mask)>>1) +
			      ((((((*(src+1))&mask)>>1) + (((*(src-1))&mask)>>1))&mask)>>1);
		src--;
	}
}


/*** KOPIERE BERECHNUNGS-PUFFER IN AUSGABE-PUFFER ***/
/* ...ein wenig in x-Richtung verzerrt, damit es netter aussieht */
void copy_calc_to_img(long w,long h,long *src,long *dst) {
	long i,j;
	long *s,*d;
	static float ang_offset;
	static float freq_offset;
	
	src+=w;
	dst+=w;

	for (j=0;j<(h-3);j++) {

		s=(src+=w) + (long)(100.0*sin((j/(60.0+40.0*sin(freq_offset))) + ang_offset));
		d=(dst+=w);	
		
		/* copy line from *s to *d */
		for (i=0;i<w;i++) *(d++) = *(s++);
	}
	ang_offset=ang_offset+0.01;
	freq_offset=freq_offset+0.023;
}


int main(int argc, char **argv) {

	/* Anlegen des Pixelspeichers (wird von beiden threads benutzt) */
	/* Es wird Speicher fr w*h Pixel angefordert. Jedes rgba-Pixel */
	/* bentigt 4 bytes */
	img_buf=(long *)malloc(img_w*img_h*4);
	calc_buf=(long *)malloc(img_w*img_h*4);

	/* Initialisierung von OpenGL mit der Hilfe der libglut */
	pthread_create(&sdl_thread_handle,NULL,&sdl_thread,NULL);
	
	/*** Hier kommt Dein eigenes Hauptprogramm.... ***/
	/* stellvertretend ein kleines Beispiel     */
	
	while (1) {

        /* berechne Bild */
        drawcrap(img_w,2,50,calc_buf+img_w*2);
		smooth(img_w,img_h,calc_buf);
		copy_calc_to_img(img_w,img_h,calc_buf,img_buf);
		
		/* gebe dem glut-thread Bescheid, da das Fenster neu gezeichnet */
		/* werden mu */
		sdl_redraw_flag=1;
		
		/* ein bischen verschnaufen... */
		usleep(20000);
	
	}
	return 0;	/* haha... */
}


