/******************************************************************************
 *
 * BEISPIEL-PROGRAMM FR DIE BENUTZUNG VON PTHREADS (OPENGL WINDOW IS A THREAD)
 * NICHT UNBEDINGT DIE SCHNELLSTE VARIANE, ABER ANSCHAULICH
 *
 * Norman Feske, Feb.2002
 *
 ******************************************************************************/


#include <stdlib.h>
#include <dlfcn.h>
#include <unistd.h>
#include <signal.h>
#include <pthread.h>

#include <math.h>
#include <stdio.h>
#include <GL/glut.h>
#include <GL/gl.h>


/* Variablen, die sowohl vom Hauptprogramm alsauch vom glut-thread */
/* verwendet werden */
long img_w=200;  /* Gre des Bildes */
long img_h=200;
long *img_buf;   /* Zeiger auf die Pixeldaten zum Darstellen*/
long *calc_buf;  /* Zeiger auf die Pixeldaten zum Berechnen */


/**************************************************************************/
/*** HIER FOLGT DER CODE DES GLUT-THREADS.                              ***/
/*** DER GLUT-THREAD KMMERT SICH UM DIE VERWALTUNG DES OPENGL-FENSTERS ***/
/*** NACH DER INITIALISIERUNG WIRD REGELMSSIG EIN FLAG BERPRFT, WAS  ***/
/*** ANZEIGT, OB EIN NEUZEICHNEN DES FENSTERS NOTWENDIG IST.            ***/
/**************************************************************************/


/*** GLUT REDRAW CALLBACK FUNKTION ***/
/* diese Funktion wird immer dann von glut aufgerufen, wenn das */
/* OpenGL-Fenster neu gezeichnet werden soll. */
void redraw(void) {

	/* erstmal alle Pixel lschen */
	/* eigentlich ist dies sinnlos, da ja sowieso das gesamte */
	/* Fenster fr die Ausgabe des Bildes verwendet wird.     */
	/* Wenn das Fenster allerdings vergrert wird, sieht es  */
	/* hlich aus. */
	glClear(GL_COLOR_BUFFER_BIT);
	
	/* setze Grafik-cursor */
	glRasterPos2i(0,0);

	/* zeichne Bild */
	glDrawPixels(img_w,img_h,GL_RGBA,GL_UNSIGNED_BYTE,(GLvoid *)img_buf);
	
	/* mache Ergebnis sichtbar */
	/* ...nur ntig, wenn mit doublebuffering gearbeitet wird */
    glutSwapBuffers();
}


/*** GLUT RESHAPE CALLBACK FUNKTION ***/
/* diese Funktion wird immer dann von glut aufgerufen, wenn das */
/* OpenGL-Fenster seine Gre ndert. */
void reshape(int w, int h) {

	/* Anpassen des Koordinatensystems */
    glViewport (0, 0, w, h);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
	gluOrtho2D(0, w, 0, h);
}


/* flag, was anzeigt, ob ein redraw notwendig ist. */
/* wenn die mainloop mit der Berechnung eines Bildes fertig ist, */
/* mu dieses flag auf 1 gesetzt werden. Der OpenGL-thread guckt */
/* regelmig (idle callback), ob das flag gesetzt ist und sorgt */
/* dann dafr, da das Fenster neu gezeichnet wird */
long glut_redraw_flag=0;


/*** GLUT IDLE CALLBACK FUNKTION ***/
/* diese Funktion wird immer dann von glut aufgerufen, wenn gerade */
/* nix anderes zu tun ist */
void idle(void) {

	/* guck nach, ob das OpenGL-Fenster neu gezeichnet werden soll...*/
	if (glut_redraw_flag) {
		glut_redraw_flag=0;
		glutPostRedisplay();
	}
}


/* Jeder Posix-Thread bentigt ein handle. */
/* ...siehe pthread_create() weiter unten. */
pthread_t glut_thread_handle;


/*** FUNKTION, DIE BEIM START DES GLUT-THREADS AUFGERUFEN WIRD. ***/
void *opengl_thread(void *arg) {
    
	glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
	glutInitWindowSize(img_w,img_h);
	glutCreateWindow("OpenGL");

	/* glut-callback-Funktionen registrieren */
	/* diese werden aufgerufen, wenn...*/
	
	/* ...das OpenGL-Fenster neu gezeichnet werden mu,...*/
	glutDisplayFunc(redraw);
	
	/* ...das OpenGL-Fenster seine Gre ndert und... */
	glutReshapeFunc(reshape);
	
	/* ...wenn grad nix weiter zu tun ist. */
	glutIdleFunc(idle);
	
	glutMainLoop();
	return NULL;
}



/**************************************************************************/
/*** EIGENTLICHES HAUPTPROGRAMM                                         ***/
/**************************************************************************/


/*** ZEICHNE ZUFLLIG EIN PAAR PIXEL ***/
void drawcrap(long max_x,long max_y,long num,long *buf) {
	long i,j,x,y;
	long mask=0xff808080;
	for (i=0;i<num;i++) {
		x=random()%max_x;
		y=random()%max_y;
		for (j=5;j--;) {
			*(buf+img_w*y+x+j)=random();
			*(buf+img_w*(y+1)+x+j)=random();
			*(buf+img_w*(y+2)+x+j)=random();
			*(buf+30+img_w*(y+1)+x+j)=0;
		}
	}
}


/*** FUNKTION ZUM 'VERWISCHEN' DES BILDES ***/
/* Entschuldigung, wegen der Klammern... */
void smooth(long w,long h,long *buf) {
	long *src=buf+w*(h-3);
	long *dst=buf+w*(h-1);
	long mask=0xfefefefe;
	long cnt;
	
	for (cnt=w*(h-3);cnt;cnt--) {
		*(dst--)= ((((((*(src+w))&mask)>>1) + (((*(src-w))&mask)>>1))&mask)>>1) +
			      ((((((*(src+1))&mask)>>1) + (((*(src-1))&mask)>>1))&mask)>>1);
		src--;
	}
}


/*** KOPIERE BERECHNUNGS-PUFFER IN AUSGABE-PUFFER ***/
/* ...ein wenig in x-Richtung verzerrt, damit es netter aussieht */
void copy_calc_to_img(long w,long h,long *src,long *dst) {
	long i,j;
	long *s,*d;
	static float ang_offset;
	static float freq_offset;
	
	src+=w;
	dst+=w;

	for (j=0;j<(h-3);j++) {

		s=(src+=w) + (long)(100.0*sin((j/(60.0+40.0*sin(freq_offset))) + ang_offset));
		d=(dst+=w);	
		
		/* copy line from *s to *d */
		for (i=0;i<w;i++) *(d++) = *(s++);
	}
	ang_offset=ang_offset+0.01;
	freq_offset=freq_offset+0.023;
}


int main(int argc, char **argv) {

	/* Anlegen des Pixelspeichers (wird von beiden threads benutzt) */
	/* Es wird Speicher fr w*h Pixel angefordert. Jedes rgba-Pixel */
	/* bentigt 4 bytes */
	img_buf=(long *)malloc(img_w*img_h*4);
	calc_buf=(long *)malloc(img_w*img_h*4);

	/* Initialisierung von OpenGL mit der Hilfe der libglut */
	glutInit(&argc,argv);
	pthread_create(&glut_thread_handle,NULL,&opengl_thread,NULL);
	
	/*** Hier kommt Dein eigenes Hauptprogramm.... ***/
	/* stellvertretend ein kleines Beispiel     */
	
	while (1) {

        /* berechne Bild */
        drawcrap(img_w,2,50,calc_buf+img_w*2);
		smooth(img_w,img_h,calc_buf);
		copy_calc_to_img(img_w,img_h,calc_buf,img_buf);
		
		/* gebe dem glut-thread Bescheid, da das Fenster neu gezeichnet */
		/* werden mu */
		glut_redraw_flag=1;
		
		/* ein bischen verschnaufen... */
		usleep(20000);
	
	}
	return 0;	/* haha... */
}


