#include <math.h>
#include <GL/glut.h>
#include <GL/gl.h>


GLfloat alph=0.0,beta=0.0,gamm=0.0;

/* Positionen und Farben der zwei Lichtquellen */
/* Die Angaben der Positionen sind x,y,z der letzte Wert Null */
/* Die Angaben der Farben sind rot, grn, blau, transparenz (alpha) */
GLfloat light_diffuse1[] = { 0.5, 0.5, 0.9, 1.0 };
GLfloat light_position1[] = { 20.0, 20.0, 20.0, 0.0 };    
GLfloat light_diffuse2[] = { 0.9, 0.7, 0.3, 1.0 };
GLfloat light_position2[] = { -20.0, 20.0, -20.0, 0.0 };


/* Redraw - glut callback Funktion */
/* Diese Funktion wird jedesmal aufgerufen, wenn der Inhalt des Fensters */
/* neu gezeichnet wird. */
void redraw(void) {

    /* Lsche alten Inhalt des Colorbuffers und Z-Buffers */
    /* Der Colorbuffer beinhaltet das Bild, was zu sehen ist. */
    /* Der Z-Buffer behinhaltet zu jedem Pixel seine Tiefeninformationen (Tiefenkarte) */
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    /* Zeichne Wrfel mit Kantenlnge 20.0 */
    /* Der Wrfel wird vor dem Zeichnen noch rotiert */
    glPushMatrix ();
    glRotatef (alph, 1.0, 0.0, 0.0);
    glRotatef (beta, 0.0, 1.0, 0.0);
    glRotatef (gamm, 0.0, 0.0, 1.0);
    //glutSolidCube (20.0);
	//glutSolidTorus(8.0,17.0,15,15);
	glutSolidTeapot(15.0);
    glPopMatrix ();

    /* Zeichne die erste Lichtquelle an ihre Position im Raum */
    /* Die Lichtquelle wird durch eine Kugel angedeutet */
    glDisable(GL_LIGHT1);
    glPushMatrix ();
    glTranslatef (light_position1[0],light_position1[1],light_position1[2]);
    glutSolidSphere (2.0,8,8);
    glPopMatrix ();
    glEnable (GL_LIGHT1);

    /* Zeichne zweite Lichtquelle */
    glDisable(GL_LIGHT0);
    glPushMatrix ();
    glTranslatef (light_position2[0],light_position2[1],light_position2[2]);
    glutSolidSphere (2.0,8,8);
    glPopMatrix ();
    glEnable (GL_LIGHT0);

    /* bisher wurden alle Ausgaben im Hintergrund durchgefhrt */
    /* Vertausche aktuellen Hintergrund und Fordergrund buffer */
    glutSwapBuffers();
}



/* Reshape - glut callback Funktion */
/* Diese Funktion wird jedesmal aufgerufen, wenn sich die Gre des Fensters */
/* ndert. Hier wird das Koordinatensystem von OpenGL an die neue Fenstergre */
/* angepat. */
void reshape(int w, int h)
{
    glViewport (0, 0, w, h);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    if (w <= h) 
	glOrtho (-25.0, 25.0, -25.0*(GLfloat)h/(GLfloat)w, 25.0*(GLfloat)h/(GLfloat)w, -25.0, 25.0);
    else 
	glOrtho (-25.0*(GLfloat)w/(GLfloat)h, 25.0*(GLfloat)w/(GLfloat)h, -25.0, 25.0, -25.0, 25.0);
    glMatrixMode (GL_MODELVIEW);
}


/* Funktion zhlt einen Winkel hoch/runter und achtet darauf, da dieser */
/* im Bereich 0..3600 bleibt */
void angle_inc(GLfloat *angle,GLfloat inc) {
	*angle=*angle+inc;
	if (*angle>3600) *angle=*angle-3600;
	if (*angle<0.0) *angle=*angle+3600;
}


/* Idle - glut callback Funktion */
/* Diese Funktion wird immer dann aufgerufen, wenn der Rechner mal */
/* grade nix tu tun hat. */
/* In dieser Funktion kann man z.Bsp. Animationsablufe festlegen */
/* Hier sollen die Rotationswinkel fr den Wrfel gendert werden. */
/* Der Funktionsaufruf 'glutPostRedisplay' bewirkt ein Neuzeichnen des */
/* Fensters. (es wird dann automatisch 'redraw' aufgerufen */
void idle(void) {
  angle_inc(&alph,0.6);
  angle_inc(&beta,1.3);
  angle_inc(&gamm,0.9);
  glutPostRedisplay();
}


int main(int argc, char **argv) {

    /* Initialisiere glut */
    glutInit(&argc,argv);
    
    /* Das Fenster soll ber die Farbkanle RGBA, Gepufferte Ausgabe */
    /* und einen Z-Buffer verfgen */
    glutInitDisplayMode(GLUT_RGBA|GLUT_DOUBLE|GLUT_DEPTH);
    
    /* Die Anfangs-Fenstergre */
    glutInitWindowSize(2*320,2*240);
    glutCreateWindow("Cube");
    
    /* Festlegen der callback Funktionen fr dieses Fenster */
    glutDisplayFunc(redraw);
    glutReshapeFunc(reshape);
    glutIdleFunc(idle);
	
    /* Definition der Farben und Positionen der beiden Lichtquellen */
    glLightfv (GL_LIGHT0, GL_DIFFUSE, light_diffuse1);
    glLightfv (GL_LIGHT0, GL_POSITION, light_position1);
    glLightfv (GL_LIGHT1, GL_DIFFUSE, light_diffuse2);
    glLightfv (GL_LIGHT1, GL_POSITION, light_position2);
    
    /* Licht einschalten */
    glEnable (GL_LIGHTING);
    glEnable (GL_LIGHT0);
    glEnable (GL_LIGHT1);
    glDisable (GL_CULL_FACE);
    
    /* Festlegen, wie mit dem Z-Buffer gearbeitet werden soll */
    /* Es werden nur Pixel berzeichnet, wenn das neue Pixel nher */
    /* am Betrachter liegt */
    glDepthFunc(GL_LESS);
    glEnable(GL_DEPTH_TEST);
    
    /* Interpolation auf Polygonen aktivieren */
    glShadeModel(GL_SMOOTH);

    /* Starte Programm Hauptschleife */
    glutMainLoop();
    return 1;
}

