
set xymark 9876

set xpos 100
set ypos 100

set xmin -20000
set xmax 20000
set ymin -20000
set ymax 20000
set zmin -20000
set zmax 20000
set wmin -20000
set wmax 20000

set sxmax 1000
set symax 1000
set szmax 1000
set swmax 1000

set xacc 1000
set yacc 1000
set zacc 1000
set wacc 1000

set poslist {}

catch {
  source settings.tcl
}

set poscurs 0

proc set_xy_speed {x y mb} {
  global xpos ypos xymark
  if {$x != ""} {
    incr x -65
    incr y -65
    set x [expr abs($x)*$x]
    set y [expr abs($y)*$y]
  }
  .rac.top.xse configure -text $x
  .rac.top.yse configure -text $y
  
  # move mouse over control area without pressed mousebutton -> stop robot
  if {$mb == -1} {
    .rac.top.xyfield configure -relief raised
    return
  }
  
  # mousebutton pressed -> robot should move
  if {$mb == 1} {
    .rac.top.xyfield configure -relief sunken
	TellController "PR $x,$y\n"
	TellController "BG XY\n"
#	set xpos [TellController "PA ?"]
#	set ypos [TellController "PA ,?"]
    incr xpos $x
	incr ypos $y
	puts "xpos:$xpos, ypos:$ypos"
    set_mark_pos $xymark $xpos $ypos
    return
  }
  
  # mouse gets outside of the control area -> stop robot
  .rac.top.xyfield configure -relief flat
}

proc set_z_speed {z {mb -1}} {
  global zpos
  if {$z != ""} {
    incr z -65
    set z [expr abs($z)*$z]
  }
  .rac.top.zse configure -text $z
  
  # move mouse over control area without pressed mousebutton -> stop robot
  if {$mb == -1} {
    .rac.top.zfield configure -relief raised
    return
  }
  
  # mousebutton pressed -> robot should move
  if {$mb == 1} {
    .rac.top.zfield configure -relief sunken
	TellController "PR ,,$z\n"
	TellController "BG Z\n"
    incr zpos $z
    return
  }
  
  # mouse gets outside of the control area -> stop robot
  .rac.top.zfield configure -relief flat
}

proc set_w_speed {w {mb -1}} {
  global wpos
  if {$w != ""} {
    incr w -65
    set w [expr abs($w)*$w]
  }
  .rac.top.wse configure -text $w
  
  # move mouse over control area without pressed mousebutton -> stop robot
  if {$mb == -1} {
    .rac.top.wfield configure -relief raised
    return
  }
  
  # mousebutton pressed -> robot should move
  if {$mb == 1} {
    .rac.top.wfield configure -relief sunken
	TellController "PR ,,,$w\n"
	TellController "BG W\n"
    incr wpos $w
#    return
  }
  
  # mouse gets outside of the control area -> stop robot
  .rac.top.wfield configure -relief flat
}


proc rel_axis_control {} {

  if {[winfo exists .rac]} return
  toplevel .rac
  wm title .rac "Relative Motion Control"
  frame .rac.top -border 1 -relief raised
  label .rac.top.xyl -text "x,y-axis control"
  label .rac.top.xyfield -image [image create photo -file rxy.gif] -border 1
  label .rac.top.xsl -text "x speed:"
  label .rac.top.xse -width 7 -border 2 -relief groove
  label .rac.top.ysl -text "y speed:"
  label .rac.top.yse -width 7 -border 2 -relief groove
  
  label .rac.top.zl -text "z-axis control"
  label .rac.top.zfield -image [image create photo -file rzw.gif] -border 1
  label .rac.top.zsl -text "z speed:"
  label .rac.top.zse -width 7 -border 2 -relief groove

  label .rac.top.wl -text "w-axis control"
  label .rac.top.wfield -image [image create photo -file rzw.gif] -border 1
  frame .rac.top.w
  label .rac.top.wsl -text "w speed:"
  label .rac.top.wse -width 7 -border 2 -relief groove

  grid .rac.top.xyl -row 0 -column 0
  grid .rac.top.xyfield -row 0 -column 1 -rowspan 2
  grid .rac.top.xsl -row 0 -column 2
  grid .rac.top.xse -row 0 -column 3
  grid .rac.top.ysl -row 1 -column 2
  grid .rac.top.yse -row 1 -column 3

  grid .rac.top.zl -row 2 -column 0
  grid .rac.top.zfield -row 2 -column 1
  grid .rac.top.zsl -row 2 -column 2
  grid .rac.top.zse -row 2 -column 3

  grid .rac.top.wl -row 3 -column 0
  grid .rac.top.wfield -row 3 -column 1
  grid .rac.top.wsl -row 3 -column 2
  grid .rac.top.wse -row 3 -column 3

  pack .rac.top -expand yes -fill both
  bind .rac.top.xyfield <Button-1> {set_xy_speed %x %y 1}
  bind .rac.top.xyfield <B1-Motion> {set_xy_speed %x %y 1}
  bind .rac.top.xyfield <ButtonRelease-1> {set_xy_speed %x %y -1}
  bind .rac.top.xyfield <Motion> {set_xy_speed %x %y -1}
  bind .rac.top.xyfield <Leave> {set_xy_speed "" "" 0}
  
  bind .rac.top.zfield <Button-1> {set_z_speed %x 1}
  bind .rac.top.zfield <B1-Motion> {set_z_speed %x 1}
  bind .rac.top.zfield <ButtonRelease-1> {set_z_speed %x -1}
  bind .rac.top.zfield <Motion> {set_z_speed %x -1}
  bind .rac.top.zfield <Leave> {set_z_speed "" 0}
  
  bind .rac.top.wfield <Button-1> {set_w_speed %x 1}
  bind .rac.top.wfield <B1-Motion> {set_w_speed %x 1}
  bind .rac.top.wfield <ButtonRelease-1> {set_w_speed %x -1}
  bind .rac.top.wfield <Motion> {set_w_speed %x -1}
  bind .rac.top.wfield <Leave> {set_w_speed "" 0}

  frame .rac.bottom
  button .rac.bottom.ok -text Close -command {destroy .rac}
  pack .rac.bottom.ok
  pack .rac.bottom -side bottom
}



proc get_draw_x {xpos} {
  global xmin xmax
  set zero [expr (256*abs($xmin)/($xmax-$xmin))]
  return [expr ($xpos*256)/($xmax-$xmin) + $zero]
}

proc get_draw_y {ypos} {
  global ymin ymax
  set zero [expr (256*abs($ymin)/($ymax-$ymin))]
  return [expr ($ypos*256)/($ymax-$ymin) + $zero]
}

proc get_real_xpos {drawx} {
  global xmin xmax
  set zero [expr (256*abs($xmin)/($xmax-$xmin))]
  return [expr (($xmax-$xmin)*($drawx - $zero))/256]
}

proc get_real_ypos {drawy} {
  global ymin ymax
  set zero [expr (256*abs($ymin)/($ymax-$ymin))]
  return [expr (($ymax-$ymin)*($drawy - $zero))/256]
}

proc set_mark_pos {mark xpos ypos {dummy 0}} {
  global xmin
  global xmax
  global ymin
  global ymax
  global xymark

  set x [get_draw_x $xpos]
  set y [get_draw_y $ypos]

  if {[winfo exists .aac.top.area]} {
    .aac.top.area coords $mark [expr $x-3] [expr $y-3] [expr $x+3] [expr $y+3]
  }
  if {$mark == $xymark} {

    TellController "PA $xpos,$ypos\n"
    TellController "BG X\n"
    TellController "BG Y\n"

  }
}


proc set_zabs_pos {zpos {dummy 0}} {
  TellController "PA ,,$zpos\n"
  TellController "BG Z"
}


proc set_wabs_pos {wpos {dummy 0}} {
  TellController "PA ,,,$wpos\n"
  TellController "BG W"
}



proc drag_mark {sx sy} {
  global xmin
  global xmax
  global ymin
  global ymax
  global xpos ypos
  global xymark
  
  set xpos [get_real_xpos $sx]
  set ypos [get_real_ypos $sy]

  set_mark_pos $xymark $xpos $ypos  
}


proc draw_coord {} {
  global xmin xmax ymin ymax
  global xpos ypos
  global xymark poslist
  set c .aac.top.area
  if {[winfo exists $c]} {
    $c delete all
    set w [lindex [$c configure -width] end]
    set h [lindex [$c configure -height] end]
    set xrange [expr $xmax - $xmin]
    set yrange [expr $ymax - $ymin]
    set xgridspace [expr $xmax / 10]

    # coordinate system  
    if {$xmin < 0} {
      if {$xmax > 0} {
        set x [get_draw_x 0]
        $c create line $x 0 $x $h -width 2 -fill black -arrow first
        $c create text [expr $x-10] 10  -text "y"
      }
    }
    if {$ymin < 0} {
      if {$ymax > 0} {
        set y [get_draw_y 0]
        $c create line 0 $y $w $y -width 2 -fill black -arrow last
        $c create text [expr $w-10] [expr $y+10] -text "x"
      }
    }

    
    .aac.top.area raise $xymark
    set xymark [$c create oval 0 0 0 0 -fill red -tag movable]
    set_mark_pos $xymark $xpos $ypos

    set oldposlist $poslist
	set poslist []
    foreach pos $oldposlist {
      set pos [lrange $pos 0 3]
	  set mrk [$c create oval 0 0 0 0 -fill blue]
	  lappend pos $mrk
	  set_mark_pos $mrk [lindex $pos 0] [lindex $pos 1]
	  #puts "positem: $pos"
      lappend poslist $pos
	}

    .aac.top.area raise $xymark

    bind $c <Button-1> {drag_mark %x %y}
    bind $c <B1-Motion> {drag_mark %x %y}
    
      
  }

}


proc abs_axis_control {} {
  global xpos
  global ypos
  global xmin xmax ymin ymax zmin zmax wmin wmax
  global xymark
  global poslist

  if {[winfo exists .aac]} return
  toplevel .aac
  wm title .aac "Absolute Position Control"
  frame .aac.top -border 1 -relief raised

  
#  draw_coord
  
  
  set c [canvas .aac.top.area -border 1 -relief flat -bg lightgray -width 256 -height 256]
#  set w [lindex [$c configure -width] end]
#  set h [lindex [$c configure -height] end]
#  for {set i 0} {$i < 20} {incr i} {
#    set y [expr ($i*$h)/20]
#    set x [expr ($i*$w)/20]
#    $c create line 0 $y $w $y -width 1 -fill darkgray
#    $c create line $x 0 $x $h -width 1 -fill darkgray
#  }
  
  
  set r [frame .aac.top.right -border 1 -relief raised]
  scale $r.xpos -from $xmin -to $xmax -variable xpos -orient horizontal -command {set_mark_pos $xymark $xpos $ypos}
  scale $r.ypos -from $ymin -to $ymax -variable ypos -orient horizontal -command {set_mark_pos $xymark $xpos $ypos}
  scale $r.zpos -from $zmin -to $zmax -variable zpos -orient horizontal -command {set_zabs_pos}
  scale $r.wpos -from $wmin -to $wmax -variable wpos -orient horizontal -command {set_wabs_pos}
  
  grid [label $r.xl -text "x position"] -row 0 -column 0
  grid $r.xpos -row 0 -column 1
  grid [label $r.yl -text "y position"] -row 1 -column 0
  grid $r.ypos -row 1 -column 1
  grid [label $r.zl -text "z position"] -row 2 -column 0
  grid $r.zpos -row 2 -column 1
  grid [label $r.wl -text "w position"] -row 3 -column 0
  grid $r.wpos -row 3 -column 1
  pack .aac.top.right -side left -expand yes -fill both
  pack .aac.top.area -side left -fill y
  
  set p [frame .aac.top.poslist -border 1 -relief raised]
  grid rowconfigure $p 2 -weight 1
  listbox $p.lb -yscrollcommand "$p.sb set"

  foreach pos $poslist {
    set xp [lindex $pos 0]
    set yp [lindex $pos 1]
    set zp [lindex $pos 2]
    set wp [lindex $pos 3]
    $p.lb insert end "($xp,$yp,$zp,$wp)"
  }

  grid $p.lb -row 2 -column 0 -sticky ns
  bind $p.lb <Double-ButtonRelease-1> {
    set s [.aac.top.poslist.lb curselection]
    if {[llength $s]} {
      set i [lindex $s 0]
      set pos [lindex $poslist $i]
      set xpos [lindex $pos 0]
      set ypos [lindex $pos 1]
      set zpos [lindex $pos 2]
      set wpos [lindex $pos 3]
      set_mark_pos $xymark $xpos $ypos
    }
  }
  bind $p.lb <ButtonRelease-1> {
    set s [.aac.top.poslist.lb curselection]
    if {[llength $s]} {
      set oldcurs [lindex $poslist $poscurs]
      .aac.top.area itemconfigure [lindex $oldcurs 4] -width 1 -fill blue -outline black
      set i [lindex $s 0]
      set pos [lindex $poslist $i]
      .aac.top.area itemconfigure [lindex $pos 4] -width 1 -fill lightblue -outline blue
      set poscurs $i
      
    }
  }
  grid [scrollbar $p.sb -orient vertical -command "$p.lb yview"] -row 2 -column 1 -sticky nsew
  set bf [frame $p.bf -border 1 -relief sunken]
  button $bf.save -text "Save Position" -command {
    set mark [.aac.top.area create oval 0 0 0 0 -fill blue]
    .aac.top.area raise $xymark
    set_mark_pos $mark $xpos $ypos
    lappend poslist [list $xpos $ypos $zpos $wpos $mark]
    .aac.top.poslist.lb insert end "($xpos,$ypos,$zpos,$wpos)"
  }
  button $bf.del -text "Delete" -command {
    set s [.aac.top.poslist.lb curselection]
    if {[llength $s]} {
      set i [lindex $s 0]
      set pos [lindex $poslist $i]
      .aac.top.area delete [lindex $pos 4]
      .aac.top.poslist.lb delete $i
      set poslist [lreplace $poslist $i $i]
    }  
  }
  pack $bf.save -side left -expand yes -fill x
  pack $bf.del -side right -expand yes -fill x
  grid $bf -row 1 -column 0 -columnspan 2 -sticky ew
  grid [label $p.l -text "position list"] -row 0 -column 0 -columnspan 2
  
  pack .aac.top.poslist -side left -expand yes -fill both
  pack .aac.top -expand yes -fill both
  draw_coord

  frame .aac.bottom
  button .aac.bottom.ok -text Close -command {destroy .aac}
  pack .aac.bottom.ok
  pack .aac.bottom -side bottom
}


set history {}
set history_pos 0

proc get_prev_hist {} {
  global history
  global history_pos
  if {$history_pos > 0} {
    incr history_pos -1;
    .t.top.e delete 0 end
    .t.top.e insert end [lindex $history $history_pos]
  }
}

proc get_next_hist {} {
  global history
  global history_pos
  if {$history_pos < [llength $history]} {
    incr history_pos
    .t.top.e delete 0 end
    .t.top.e insert end [lindex $history $history_pos]
  }
}

proc eval_command {} {
  global history
  global history_pos
  set command [.t.top.e get]
  .t.top.text configure -state normal
  .t.top.text insert insert  "$command\n" {tellcol}
  .t.top.text insert insert [TellController $command] {replycol}
  .t.top.text insert insert "\n"
  .t.top.text configure -state disabled
  .t.top.text see end
  if {$command != [lindex $history end]} {
    lappend history $command
  }
  set history_pos [llength $history]
  .t.top.e delete 0 end
}

proc terminal {} {
  if {[winfo exists .t]} return
  toplevel .t
  wm title .t "Controller Terminal"
  frame .t.top -border 1 -relief raised
  text .t.top.text -xscrollcommand {.t.top.hsb set} \
                   -yscrollcommand {.t.top.vsb set} \
                   -state disabled \
                   -bg black \
                   -width 64 -height 16
  .t.top.text tag configure tellcol -foreground #aaccff
  .t.top.text tag configure replycol -foreground #ffffaa
  scrollbar .t.top.vsb -orient vertical -command {.t.top.text yview}
  scrollbar .t.top.hsb -orient horizontal -command {.t.top.text xview}
  grid .t.top.text -row 0 -column 0 -sticky nsew
  grid .t.top.vsb -row 0 -column 1 -sticky ns
  grid .t.top.hsb -row 1 -column 0 -sticky ew
  grid columnconfigure .t.top 0 -weight 1
  grid rowconfigure .t.top 0 -weight 1
  pack .t.top -expand yes -fill both
  entry .t.top.e
  grid .t.top.e -row 2 -column 0 -columnspan 2 -sticky ew
  bind .t.top.e <Key-Return> eval_command
  bind .t.top.e <Up> get_prev_hist
  bind .t.top.e <Down> get_next_hist
  
  frame .t.bottom
  button .t.bottom.ok -text Close -command {destroy .t}
  pack .t.bottom.ok
  pack .t.bottom -side bottom  
}



proc updatemax {minname maxname dummy} {
  global $minname $maxname
  eval "if {\$$maxname <= \$$minname} {set $maxname [expr \$$minname + 1]}"
  if {$minname=="xmin"} {set axis xpos}
  if {$minname=="ymin"} {set axis ypos}
  if {$minname=="zmin"} {set axis zpos}
  if {$minname=="wmin"} {set axis wpos}
  eval "if {[winfo exists .aac.top.right.$axis]} {.aac.top.right.$axis configure -from \$$minname -to \$$maxname}"
  draw_coord
}

proc updatemin {minname maxname dummy} {
  global $minname $maxname
  eval "if {\$$maxname <= \$$minname} {set $minname [expr \$$maxname - 1]}"
  if {$minname=="xmin"} {set axis xpos}
  if {$minname=="ymin"} {set axis ypos}
  if {$minname=="zmin"} {set axis zpos}
  if {$minname=="wmin"} {set axis wpos}
  eval "if {[winfo exists .aac.top.right.$axis]} {.aac.top.right.$axis configure -from \$$minname -to \$$maxname}"
  draw_coord
}

proc updatemaxspeed {dummy} {
  global sxmax symax szmax swmax
  TellController "SP $sxmax,$symax,$szmax,$swmax\n"
}


proc updateacc {dummy} {
  global xacc yacc zacc wacc
  TellController "AC $xacc,$yacc,$zacc,$wacc\n"
}


proc settings {} {
  if {[winfo exists .s]} return
  toplevel .s
  wm title .s "Settings"
  
  frame .s.s -border 1 -relief raised
  label .s.s.l -text "maximal axis speed"
  scale .s.s.maxx -from 0 -to 10000 -variable sxmax -orient horizontal -command "updatemaxspeed"
  scale .s.s.maxy -from 0 -to 10000 -variable symax -orient horizontal -command "updatemaxspeed"
  scale .s.s.maxz -from 0 -to 10000 -variable szmax -orient horizontal -command "updatemaxspeed"
  scale .s.s.maxw -from 0 -to 10000 -variable swmax -orient horizontal -command "updatemaxspeed"

  grid .s.s.l -row 0 -column 0 -columnspan 2
  grid [label .s.s.maxxl -text "x:"] -row 1 -column 0
  grid [label .s.s.maxyl -text "y:"] -row 2 -column 0
  grid [label .s.s.maxzl -text "z:"] -row 3 -column 0
  grid [label .s.s.maxwl -text "w:"] -row 4 -column 0
  grid .s.s.maxx -row 1 -column 1
  grid .s.s.maxy -row 2 -column 1
  grid .s.s.maxz -row 3 -column 1
  grid .s.s.maxw -row 4 -column 1
  pack .s.s -expand yes -fill both


  frame .s.min -border 1 -relief raised
  label .s.min.l -text "minimal position"
  scale .s.min.x -from -40000 -to 40000 -variable xmin -orient horizontal -command "updatemin xmin xmax"
  scale .s.min.y -from -40000 -to 40000 -variable ymin -orient horizontal -command "updatemin ymin ymax"
  scale .s.min.z -from -40000 -to 40000 -variable zmin -orient horizontal -command "updatemin zmin zmax"
  scale .s.min.w -from -40000 -to 40000 -variable wmin -orient horizontal -command "updatemin wmin wmax"

  grid .s.min.l -row 0 -column 0 -columnspan 2
  grid [label .s.min.xl -text "x:"] -row 1 -column 0
  grid [label .s.min.yl -text "y:"] -row 2 -column 0
  grid [label .s.min.zl -text "z:"] -row 3 -column 0
  grid [label .s.min.wl -text "w:"] -row 4 -column 0
  grid .s.min.x -row 1 -column 1
  grid .s.min.y -row 2 -column 1
  grid .s.min.z -row 3 -column 1
  grid .s.min.w -row 4 -column 1
  pack .s.min -expand yes -fill both


  frame .s.max -border 1 -relief raised
  label .s.max.l -text "maximal position"
  scale .s.max.x -from -40000 -to 40000 -variable xmax -orient horizontal -command "updatemax xmin xmax"
  scale .s.max.y -from -40000 -to 40000 -variable ymax -orient horizontal -command "updatemax ymin ymax"
  scale .s.max.z -from -40000 -to 40000 -variable zmax -orient horizontal -command "updatemax zmin zmax"
  scale .s.max.w -from -40000 -to 40000 -variable wmax -orient horizontal -command "updatemax wmin wmax"
  

  grid .s.max.l -row 0 -column 0 -columnspan 2
  grid [label .s.max.xl -text "x:"] -row 1 -column 0
  grid [label .s.max.yl -text "y:"] -row 2 -column 0
  grid [label .s.max.zl -text "z:"] -row 3 -column 0
  grid [label .s.max.wl -text "w:"] -row 4 -column 0
  grid .s.max.x -row 1 -column 1
  grid .s.max.y -row 2 -column 1
  grid .s.max.z -row 3 -column 1
  grid .s.max.w -row 4 -column 1
  pack .s.max -expand yes -fill both




  frame .s.a -border 1 -relief raised
  label .s.a.l -text "axis acceleration"
  scale .s.a.maxx -from 0 -to 50000 -variable xacc -orient horizontal -command "updateacc"
  scale .s.a.maxy -from 0 -to 50000 -variable yacc -orient horizontal -command "updateacc"
  scale .s.a.maxz -from 0 -to 50000 -variable zacc -orient horizontal -command "updateacc"
  scale .s.a.maxw -from 0 -to 50000 -variable wacc -orient horizontal -command "updateacc"

  grid .s.a.l -row 0 -column 0 -columnspan 2
  grid [label .s.a.maxxl -text "x:"] -row 1 -column 0
  grid [label .s.a.maxyl -text "y:"] -row 2 -column 0
  grid [label .s.a.maxzl -text "z:"] -row 3 -column 0
  grid [label .s.a.maxwl -text "w:"] -row 4 -column 0
  grid .s.a.maxx -row 1 -column 1
  grid .s.a.maxy -row 2 -column 1
  grid .s.a.maxz -row 3 -column 1
  grid .s.a.maxw -row 4 -column 1
  
  grid .s.min -column 0 -row 0 -sticky nsew
  grid .s.max -column 1 -row 0 -sticky nsew
  grid .s.s -column 2 -row 0 -sticky nsew
  grid .s.a -column 3 -row 0 -sticky nsew
      
  grid columnconfigure .s 0 -weight 1
  grid columnconfigure .s 1 -weight 1
  grid columnconfigure .s 2 -weight 1
  grid columnconfigure .s 3 -weight 1
  grid rowconfigure .s 0 -weight 1
    
  frame .s.bottom
  button .s.bottom.ok -text Close -command {destroy .s}
  pack .s.bottom.ok
  grid .s.bottom -row 100 -column 0 -columnspan 99
}


proc exit_prg {} {
  global xpos ypos zpos wpos xmin xmax ymin ymax zmin zmax wmin wmax sxmax symax szmax swmax\
                       xacc yacc zacc wacc poslist
  set parameters [list xpos ypos zpos wpos \
                       xmin ymin zmin wmin \
					   xmax ymax zmax wmax \
					   sxmax symax szmax swmax\
                       xacc yacc zacc wacc]
#  global $parameters
  set fh [open "settings.tcl" w]

  foreach par $parameters {
    set cmd "puts $fh \"set $par \$$par\"\n"
	eval $cmd
  }
  puts $fh "set poslist {}"
  foreach pos $poslist {
    set xp [lindex $pos 0]
    set yp [lindex $pos 1]
    set zp [lindex $pos 2]
    set wp [lindex $pos 3]
    puts $fh "lappend poslist { $xp $yp $zp $wp 9876 }"
  }

  close $fh

  exit
}


proc definezero {} {
  global xpos ypos zpos wpos xymark
  TellController "DP 0,0,0,0\n"
  set xpos 0
  set ypos 0
  set zpos 0
  set wpos 0
  set_mark_pos $xymark 0 0
}


frame .top -border 1 -relief raised
pack [button .top.rel_control -text "Relative Axis Control" -command rel_axis_control] -fill x
pack [button .top.abs_control -text "Absolute Axis Control" -command abs_axis_control] -fill x
pack [button .top.terminal -text "Controller Terminal" -command terminal] -fill x
pack [button .top.settings -text "Settings" -command settings] -fill x
pack [button .top.defzero -text "Define Zero" -command definezero] -fill x
pack .top -side top -fill both -expand yes
pack [button .exit -text "Exit" -command exit_prg] -side bottom


# move robot to initial position (not really needed)
TellController "SB1\n"
TellController "SB2\n"
#TellController "PA 0,0,0,0\n"
#TellController "BG X\n"
#TellController "BG Y\n"
#TellController "BG Z\n"
#TellController "BG W\n"



#
# HANDLE INCOMING SOCKET CONNECTIONS
#
proc handle_socket_connection {channel client_adress client_port} {
	global accept_host
	if {$client_adress != $accept_host} {
		return
	}
	set command [gets $channel]
	set result [TellController "$command"]
	flush $channel
	puts $channel $result
	close $channel
}

set port 6593
set sh [socket -server handle_socket_connection $port]
set accept_host "141.76.30.123"


#settings
#abs_axis_control
