#define WINDOWS 0

#include <tk.h>

#if WINDOWS
#include <windows.h>
#include <dmccom.h>
#else //LINUX
#include <libgalil.h>
#endif


int Tcl_AppInit(Tcl_Interp *interp);

#if WINDOWS

char *msg = "wird gemacht.";
char        szBuffer[256];
HANDLEDMC   hDmc;

#endif


int TellController(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[]) {

#if WINDOWS

  long  rc = 0L;

  rc = DMCCommand(hDmc, argv[1], szBuffer, sizeof(szBuffer));
  if (rc) {
    //printf("Communication failure. RC=%ld\n", rc);
  } 
  //printf("%s",szBuffer);
  interp->result=szBuffer;
  
#else //LINUX

  interp->result=GalilSendCommand(argv[1]);
  
#endif

  return TCL_OK;
}



int Init_Controller(void) {

#if WINDOWS

  long  rc = 0L;
 
  /* Open a handle to controller number 1 */
  rc = DMCOpen(1, 0, &hDmc);
  if (rc) {
    printf("Could not open controller number 1. RC=%ld\n", rc);
    return rc;
  }	
  strcpy(szBuffer, "#A\r\nSP500\r\nPR1000\r\nBGX\r\nEN");

#else //LINUX

  GalilInit();
  
#endif

  return 1;
}



void Deinit_Controller(void) {    

#if WINDOWS
  DMCClose(hDmc);
#else //LINUX
  GalilDeinit();
#endif

}


main(int argc, char *argv[]) {
	Init_Controller();
	Tk_Main(argc, argv, Tcl_AppInit);	
}


int Tcl_AppInit(Tcl_Interp *interp) {

	if (Tcl_Init(interp) == TCL_ERROR) return TCL_ERROR;
	Tk_Init(interp);	
	Tcl_CreateCommand(interp,"TellController",TellController,(ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
	Tcl_SetVar(interp, "tcl_rcFileName", "robo.tcl",
		TCL_GLOBAL_ONLY);
	return TCL_OK;
}

