
/*****************************************************************/
/* Shared Library for an easy use of the galil motion controller */
/*                                                               */
/* based on the galil terminal demonstration program... argh!    */
/* (c) and written by Norman Feske in 2001                       */
/*****************************************************************/



#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#include "dmclnx.h"
#include "dmcdrc.h"


#define RESPONSE_BUFFERSIZE 256
CONTROLLERINFO 	controllerinfo;		/* Controller information structure */
HANDLEDMC      	dmc_handle = -1;		/* Handle for controller */
char			response_buffer[RESPONSE_BUFFERSIZE];


/*** INITIALISE CONTROLLER (ASSUMING A PCI CONTROLLER) ***
 * returns 1 if initialisation was successful or 0 if an error occured 
 */
int GalilInit(void) {

	/* fill controller information structure */
	memset(&controllerinfo, '\0', sizeof(controllerinfo));
	controllerinfo.cbSize = sizeof(controllerinfo);
	controllerinfo.usModelID = MODEL_1802;
	controllerinfo.fControllerType = ControllerTypePCIBus;
	controllerinfo.ulTimeout = 10000;
	controllerinfo.hardwareinfo.businfo.fDataRecordAccess = DataRecordAccessFIFO;

	/* init DMC library */
  	DMCInitLibrary();
  
  	/* Open the connection to the controller */
	if (DMCOpen( &controllerinfo, &dmc_handle )) return 0;
  	else return 1;
}


/*** DEINITIALISE CONTROLLER ***/
void GalilDeinit(void) {
	DMCClose(dmc_handle);
}


/*** SEND AN ASCII COMMAND TO THE CONTROLLER AND RETURNS THE CONTROLLER RESPONSE ***/
char *GalilSendCommand(char *command) {
	DMCCommand(dmc_handle,command,response_buffer,RESPONSE_BUFFERSIZE);
	return response_buffer;
}

