//
// galilpci.h
//

#include <linux/ioctl.h>
#include "pciioctl.h"

//	version dependencies have been confined to a separate file

#include "sysdep.h"

//#undef PDEBUG
//#ifdef SCULL_DEBUG
//#  ifdef __KERNEL__
//     /* This one if debugging is on, and kernel space */
//#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "scull: " fmt, ## args)
//#  else
//     /* This one for user space */
//#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
//#  endif
//#else
//#  define PDEBUG(fmt, args...) /* not debugging: nothing */
//#endif

//#undef PDEBUGG
//#define PDEBUGG(fmt, args...)  /* nothing: it's a placeholder */

#define DRIVER_NAME		"galilpci"

#ifndef DEVICE_MAJOR
#define DEVICE_MAJOR		1	    /* dynamic major by default */
#endif

#ifndef TRUE
#define TRUE	1
#endif	
#ifndef FALSE
#define FALSE	0
#endif	

#define MEM_SIZE						16
#define MEM1_SIZE						4
#define	MEM2_SIZE						128
#define MAX_INTERRUPTS			16
#define MAX_DEVICES					4
#define DEFAULT_MODEL				1800
#define DEFAULT_ADDRESS			824
#define DEFAULT_INTERRUPT		11
#define BUFFER_SIZE					4096
#define DEFAULT_TIMEOUT			100
#define GALILPCI_MAX_DEVICE	32

#define DATA_ADDR						0
#define STATUS_ADDR					1

enum DMCBusIOStyle
{
   DMC600IOStyle = 0,            // For DMC-600, DMC-1400
   DMC1000IOStyle = 1,           // For DMC-1200, DMC-1000, DMC-1700, DMC-1802, DMC-1417
   DMC1600IOStyle = 2            // For DMC-1600, DMC-1800
};

enum DMCInterruptStyle
{
   DMC1000InterruptStyle = 0,    // For DMC-1000
   DMC1400InterruptStyle = 1,    // For DMC-1400, DMC-1417
   DMC1700InterruptStyle = 2,    // For DMC-1200, DMC-1700, DMC-1802
   DMC1600InterruptStyle = 3,    // For DMC-1600, DMC-1800
   DMCNoInterruptStyle = 99      // No interrupts
};

enum DMCDataRecordAccess
{
   DataRecordAccessNone = 0,     /* No data record access capability or data record access is off */
   DataRecordAccessDMA = 1,      /* Use DMA for data record access */
   DataRecordAccessFIFO = 2      /* Use FIFO for data record access */
};

//
// Galil device structure
//
#define MAX_INTERRUPTS 16
typedef struct _GALILDEVICE
{
	int							Model;
	int							IOType;
	int							InterruptType;
	unsigned long 	SerialNumber;
	int							context;
	unsigned long		Address;
	unsigned long		Address2;
	int							Interrupt;
	int							InterruptCount;
  unsigned short	InterruptStatus[ MAX_INTERRUPTS ];
	char						Buffer[ BUFFER_SIZE ];
} GALILDEVICE, *PGALILDEVICE;

// Split minors in two parts
//#define TYPE(dev)   (MINOR(dev) >> 4)  /* high nibble */
#define NUM(dev)    (MINOR(dev) & 0xf) /* low  nibble */

// File operation table
//extern struct file_operations galilisa_fops;

//#ifdef GALIL_DEBUG
//#  if LINUX_VERSION_CODE > VERSION_CODE(1,99,3) /* 1.99.4 exported the needed symbols */
//#    define GALIL_USE_PROC
//#  endif
//#endif

#undef	min
#define min(a,b) ((a)<(b) ? (a) : (b))

#undef	MAKEWORD
#define MAKEWORD(a, b) ((u16)(((u8)(a))|((u16)((u8)(b)))<<8)) 

#undef	TOLOWER
#define	TOLOWER(x)	((((x) >= 'A') && ((x) <= 'Z')) ? ((x) + 0x20) : (x))
 
#define VENDOR_ID             0x10B5 // PLX vendor ID
#define DEVICE_ID             0x9050 // PLX device ID
#define SUB_VENDOR            0x1079 // Galil subsytem vendor ID
#define SUB_DEVICE_1600       0x1640 // Galil subsystem device ID
#define SUB_DEVICE_1800       0x1800 // Galil subsystem device ID
#define SUB_DEVICE_1842       0x1842 // Galil subsystem device ID
#define SUB_DEVICE_1417       0x1417 // Galil subsystem device ID

#define MODEL_UNKNOWN          0
#define MODEL_100              100
#define MODEL_200              200
#define MODEL_600              600
#define MODEL_700              700
#define MODEL_1000             1000
#define MODEL_1200             1200
#define MODEL_1410             1410
#define MODEL_1411             1411
#define MODEL_1412             1412
#define MODEL_1415             1415
#define MODEL_1417             1417
#define MODEL_1500             1500
#define MODEL_1600             1600
#define MODEL_1700             1700
#define MODEL_1800             1800
#define MODEL_1802             1802
#define MODEL_2000             2000
#define MODEL_2100             2100
