
/* 
 * ADVANTECH PCL726 ISA DEVICE DRIVER
 *
 * This driver is written and tested under suse linux 7.2.
 * Change the define below to modify the i/o base adress of your card.
 *
 * written by Norman Feske 2001
 */

#define DEBUG 1
#define IO_BASE 0x2c0

/* Standard in kernel modules */
#include <linux/kernel.h>   /* We're doing kernel work */
#include <linux/module.h>   /* Specifically, a module */

/* Deal with CONFIG_MODVERSIONS */
#if CONFIG_MODVERSIONS==1
#define MODVERSIONS
#include <linux/modversions.h>
#endif        

/* For character devices */
#include <linux/fs.h>       /* The character device 
                             * definitions are here */
#include <linux/wrapper.h>  /* A wrapper which does 
                             * next to nothing at
                             * at present, but may 
                             * help for compatibility
                             * with future versions 
                             * of Linux */
#include <linux/ioctl.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/config.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/uaccess.h>

/* In 2.2.3 /usr/include/linux/version.h includes 
 * a macro for this, but 2.0.35 doesn't - so I add 
 * it here if necessary. */
#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c) ((a)*65536+(b)*256+(c))
#endif


/* Conditional compilation. LINUX_VERSION_CODE is 
 * the code (as per KERNEL_VERSION) of this version. */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,2,0)
#include <asm/uaccess.h>  /* for put_user */
#endif

                             

#define SUCCESS 0


/* Device Declarations **************************** */

/* The name for our device, as it will appear 
 * in /proc/devices */
#define DEVICE_NAME "pcl_da"

/* The maximum length of the message from the device */
#define BUF_LEN 80

/* Is the device open right now? Used to prevent 
 * concurent access into the same device */
static int Device_Open = 0;

/* This function is called whenever a process 
 * attempts to open the device file 
 * ...not needed */
 
static int device_open(struct inode *inode, 
                       struct file *file)
{

#ifdef DEBUG
  printk ("device_open(%p,%p)\n", inode, file);
#endif

  return SUCCESS;
}


/* This function is called when a process closes the 
 * device file. It doesn't have a return value in 
 * version 2.0.x because it can't fail (you must ALWAYS
 * be able to close a device). In version 2.2.x it is 
 * allowed to fail - but we won't let it. 
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static int device_release(struct inode *inode, 
                          struct file *file)
#else 
static void device_release(struct inode *inode, 
                           struct file *file)
#endif
{
#ifdef DEBUG
  printk ("device_release(%p,%p)\n", inode, file);
#endif
 

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  return 0;
#endif
}



void set_channel_da(int ch,long value) { 
  outb((unsigned char)((value >> 8) & 0xff),IO_BASE + 2*ch);
  outb((unsigned char)((value) & 0xff),IO_BASE + 2*ch + 1);
}



/* very poor string to long conversion */
/* ...anyway - it works... at least mostly :) */
unsigned long atol(char *src) {
  long result=0;
  while ((*src >= '0') && ((*src) <= '9')) result=result*10 + (*(src++) & 0xf);
  return result;
}




char local_buf[81];


/* This function is called when somebody tries to write 
 * into our device file - unsupported in this example. */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t device_write(struct file *file,
    const char *buffer,    /* The buffer */
    size_t length,   /* The length of the buffer */
    loff_t *offset)  /* Our offset in the file */
#else


static int device_write(struct inode *inode,
                        struct file *file,
                        const char *buffer,
                        int length)
#endif
{
  long value;
  int minlen=80;
  unsigned int minor = MINOR(file->f_dentry->d_inode->i_rdev);
  if (minor>5) return -EINVAL;
  
  if (length<minlen) minlen=length;
  
  copy_from_user(local_buf,buffer,minlen);
  *(local_buf+minlen)=0; /* terminate string */
  value = atol(local_buf);
  
#ifdef DEBUG
  printk("somebody tries to write to pcl_do%i\n",minor);
  printk("new value: %ld\n",value);
  printk("setting d/a value...");
  set_channel_da(minor,value);
  printk("ok.\n");
#endif
  
  return -EINVAL;
}




/* Module Declarations ***************************** */

static int Major;

struct file_operations Fops = {
  NULL,   /* owner */
  NULL,   /* seek */
  NULL,	  /*  device_read, */
  device_write,
  NULL,   /* readdir */
  NULL,   /* select */
  NULL,   /* ioctl */
  NULL,   /* mmap */
  device_open,
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  NULL,   /* flush */
#endif

  device_release,  /* a.k.a. close */
  
  NULL,   /* fsync */
  NULL,   /* fasync */
  NULL,   /* lock */
  NULL,   /* readv */
  NULL,   /* writev */
};


/* Initialize the module - Register the character device */
int init_module()
{
  /* Register the character device (atleast try) */
  Major = register_chrdev(0, 
                                 DEVICE_NAME,
                                 &Fops);

  /* Negative values signify an error */
  if (Major < 0) {
    printk ("pcl726: %s device failed with %d\n",
            "Sorry, registering the character",
            Major);
    return Major;
  }

  printk ("pcl726: %s The major device number is %d.\n",
          "Registeration is a success.",
          Major);

  return 0;
}


/* Cleanup - unregister the appropriate file from /proc */
void cleanup_module()
{
  int ret;

  /* Unregister the device */
  ret = unregister_chrdev(Major, DEVICE_NAME);
 
  /* If there's an error, report it */ 
  if (ret < 0)
    printk("Error in unregister_chrdev: %d\n", ret);
}
