/* $Id: stats.c,v 1.2 2007/01/12 12:01:00 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file stats.c
 *  \brief Stastistics helper functions
 * 
 *  \date 12/31/06 13:07:00 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
#include "__types.h"
#include "__lxcalls.h"

lx_task_stats_t * lx_stats_get_free(lx_task_t * task)
{
	lx_stats.task[lx_stats.task_len].task_id = task->task_id;
	lx_stats.task[lx_stats.task_len].page_cnt = 0;
	lx_stats.task_len++;
	
	return &(lx_stats.task[lx_stats.task_len - 1]);
}

int lx_stats_get_task(lx_task_t * task, lx_task_stats_t ** stats)
{
	int pos = 0;
	while(pos < lx_stats.task_len && 
			!l4_task_equal(task->task_id, lx_stats.task[pos].task_id))
		pos++;
	*stats = &(lx_stats.task[pos]);
	return pos;
}


void lx_stats_set_free(lx_task_t * task)
{
	lx_task_stats_t * stat_task;
	int pos;

	pos = lx_stats_get_task(task, &stat_task);

	if(pos < lx_stats.task_len - 1)
		memmove((void*)&(lx_stats.task[pos]), (void*)&(lx_stats.task[pos + 1]),
				(lx_stats.task_len - pos - 1) * sizeof(lx_task_stats_t));
	
	lx_stats.task_len--;
}
