/* $Id:$ */
/*****************************************************************************/
/**
 *  \file profile.c
 *  \brief Freezer profiling 
 * 
 *  \date 03/14/07 13:10:04 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
#include<l4/util/rdtsc.h>

#include "lxfreeze-server.h"
#include "__types.h"
#include "__lxcalls.h"


void lx_timer(void)
{
	static int state = 0;
	static l4_cpu_time_t tsc1, tsc2;	
	static int call = 0;
	l4_uint64_t tns;
	call++;
	
	if(state)
	{
		tsc2 = l4_rdtsc();
		tns = l4_tsc_to_ns(tsc2 - tsc1);
		LOGd(PROFILE, "%llu ns (# %d)", tns, call);
		state = 0;
	}
	else
	{	
		tsc1 = l4_rdtsc();
		state = 1;
	}
}

void lx_timer_init(void)
{
	if(!l4_tsc_init(L4_TSC_INIT_KERNEL))
		LOGd(DBG_ERROR, "TIMER initialization failed\n");
}

/* external interface to timer */
void
if_l4dm_lxfreeze_timer_component (CORBA_Object _dice_corba_obj,
                                  CORBA_Server_Environment *_dice_corba_env)
{
		lx_timer();
}

