/* $Id: main.c,v 1.3 2007/01/25 15:13:06 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file init.c
 *  \brief initialize datastructures 
 * 
 *  \date 12/20/06 12:03:09 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
#include <l4/names/libnames.h>
#include <l4/sys/syscalls.h>
#include <l4/util/macros.h>
#include <l4/util/parse_cmd.h>

#include "__types.h"
#include "__lxcalls.h"
#include "lxfreeze-server.h"

char LOG_tag[9] = LX_FREEZE;

/*******************************************************************************
 *** globals 
 ******************************************************************************/
lx_task_t lx_tasks[LX_MAX_INSTANCES];
lx_stats_t lx_stats;
int lx_frozen = 0;
l4_threadid_t lx_main_thread;
l4_threadid_t loader_id;
l4semaphore_t lx_clean_sem = L4SEMAPHORE_INIT(1);

/*******************************************************************************
 *** options 
 ******************************************************************************/
static int opt_events;


static void * malloc(unsigned long size)
{
	if(!size)
		return NULL;
	return l4dm_mem_allocate_named(size, 0, "DICE");
}

static void free(void * ptr)
{
	l4dm_mem_release(ptr);
}

static void * __dsmlib_grow(void ** data)
{
	return l4dm_mem_allocate_named(L4_PAGESIZE, L4RM_MAP, "dsmlib memory");
}

static void __dsmlib_shrink(void * page, void * data)
{
	l4dm_mem_release(page);
}

static int lx_init(void) 
{
	int error;
	int i;
	lx_task_init();
	
	//init/start paging thread
	if((error = lx_pager_init()))
		return error;
				
	//init stats
	lx_stats.page_frozen = lx_stats.page_ref = 
		lx_stats.mem_overhead = lx_stats.mem_usage = lx_stats.mem_total =
		lx_stats.mem_free = lx_stats.task_len = lx_stats.hash_hot_cnt = 0;
	for(i = 0; i < LX_HASH_LEVELS; i++)
		lx_stats.hash_collisions[i] = lx_stats.hash_matches[i] = 0;
	lx_stats.hash_len = LX_HASH_LEVELS;

	for(i = 0; i < LX_MAX_INSTANCES; i++)
	{
		lx_stats.task[i].page_cnt = 0;
		lx_stats.task[i].task_id = L4_INVALID_ID;
	}
	return 0;
}
		
int main(int argc, const char ** argv)
{
	DICE_DECLARE_SERVER_ENV(env);
	int error;

	if ((error = parse_cmdline(&argc, &argv,
	     'e', "events", "enable exit handling via events",
	     PARSE_CMD_SWITCH, 1, &opt_events, 0)))
	{
		switch (error)
		{
			case -1: LOG_printf("Bad parameter for parse_cmdline()\n"); break;
			case -2: LOG_printf("Out of memory in parse_cmdline()\n"); break;
			default: LOG_printf("Error %d in parse_cmdline()\n", error); break;
		}
		return -1;
	}
	
	lx_main_thread = l4_myself();
	
	if(lx_init())
		return -2;

	if(dsmlib_init(__dsmlib_grow, __dsmlib_shrink))
		return -3;

	
	lx_event_init();
	//if(opt_events && lx_event_init())
	//	return 1;
	
	names_register(LX_FREEZE);
	
#if PROFILE
	lx_timer_init();
#endif
	
	if((error = lx_hash_start()))
	{
		LOGd(DBG_ERROR, "Failed to start hasher\n");
		return -4;
	}
	
	if(!names_waitfor_name("LOADER", &loader_id, 30000))
	{
		LOGd(DBG_ERROR, "Dynamic loader LOADER not found -- terminating");
		return -5;
	}

	env.malloc = malloc;
	env.free   = free;
	LOGd(DBG_VERB, "lxfreezer started ("l4util_idfmt")\n", l4util_idstr(l4_myself()));
	if_l4dm_lxfreeze_server_loop(&env);
	return 0;
}

