/* $Id: event.c,v 1.1 2007/01/12 12:01:32 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file event.c
 *  \brief listens for linux exit events 
 * 
 *  \date Tue Oct  9 15:20:35 CEST 2007
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
#include <l4/events/events.h>
#include <l4/lxfreeze/lxfreeze-client.h>

#ifdef USE_TASKLIB
#include <l4/task/task_server.h>
#endif

#include "__types.h"
#include "__lxcalls.h"

static void __events_wait(void * data)
{
	l4events_ch_t	event_ch = L4EVENTS_EXIT_CHANNEL;
	l4events_nr_t	event_nr = L4EVENTS_NO_NR;
	l4events_event_t event;

	/* init event lib and register for event */
	l4events_init();
	l4events_register(event_ch, 12);

	LOGdL(DBG_EVENTS, "event thread up.");

	l4_threadid_t tid;
	long res;
	DICE_DECLARE_ENV(_env);
	/* event loop */
	for (;;)
	{

		/* wait for event */
		res = l4events_give_ack_and_receive(&event_ch, &event, &event_nr,
                                        L4_IPC_NEVER, L4EVENTS_RECV_ACK);
		if (res != L4EVENTS_OK)
		{
			LOGdL(DBG_EVENTS, "Got bad event (result=%ld, %s)",
			      res, l4env_errstr(res));
			continue;
		}

		tid = *(l4_threadid_t *)event.str;

		LOGdL(DBG_EVENTS, "Got exit event for "l4util_idfmt,
		      l4util_idstr(tid));

		if_l4dm_lxfreeze_linux_exit_call(&lx_main_thread, &tid, &_env);

		if (DICE_HAS_EXCEPTION(&_env))
			LOG_Error("handle exit event: call to service thread failed " \
			          "(exc %d)!", DICE_EXCEPTION_MAJOR(&_env));
	}
}

#ifdef USE_TASKLIB
static long tasklib_send_exit_event(l4_threadid_t client, char *status) 
{
	l4events_event_t event;
	l4events_nr_t event_nr;

	/* generate exit event at event server */
	event.len = sizeof(l4_threadid_t);
	*(l4_threadid_t*)event.str = client;

	if(l4events_send(L4EVENTS_EXIT_CHANNEL, &event, &event_nr, L4EVENTS_ASYNC))
		return -L4_EUNKNOWN;

	return 0;
}
#endif

static void tasklib_register_hooks(void) 
{
#ifdef USE_TASKLIB
	l4task_server_callbacks cb = {NULL, NULL, NULL, tasklib_send_exit_event};
	l4task_server_register_hooks(cb);
#endif
}

int
lx_event_init(void) 
{
	tasklib_register_hooks();
	return l4thread_create_named(__events_wait, ".event", NULL, L4THREAD_CREATE_ASYNC);
}
