/* $Id: __lxcalls.h,v 1.3 2007/01/25 15:13:06 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file __lxcalls.h
 *  \brief global calls 
 * 
 *  \date 12/20/06 12:58:08 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
#include <l4/slab/slab.h>
/* pager.c */

int lx_pager_init(void);
l4_threadid_t lx_pager_get_id(void);
int lx_pager_add_ds(lx_page_fault_t ds);
void lx_pager_del_ds(unsigned long ds_id);
void lx_pager_chk_release(void);

/* slab.c */
int lx_slab_setup(l4slab_cache_t * cache, l4_size_t obj_size);
void * lx_slab_alloc(l4slab_cache_t * cache);
void lx_slab_free(l4slab_cache_t * cache, void * obj);

/* cow_mem.c */
void * lx_cow_get_free(void);
void lx_cow_set_free(l4_addr_t addr);
void * lx_cow_chk_moved(l4_addr_t addr);
void lx_cow_compactify(void);

/* pages.c */
int lx_task_init(void);

int lx_task_add_pos(l4_taskid_t task_id, int pos);
L4_INLINE int lx_task_add(l4_taskid_t task_id);	

int lx_task_do_get(l4_taskid_t task_id, int pos, lx_task_t ** task);
L4_INLINE int lx_task_get_pos(int pos, lx_task_t ** task);
L4_INLINE int lx_task_get(l4_taskid_t task_id, lx_task_t ** task);
lx_task_t * lx_task_get_frozen(void);
lx_task_t * lx_task_get_foster(void);
void lx_task_del(lx_task_t * task, int pos);

int lx_ds_add(lx_task_t * task, l4dm_dataspace_t ds, dsmlib_ds_desc_t * ds_desc, 
              l4_size_t size);
int lx_ds_add_addr(l4dm_dataspace_t ds, dsmlib_ds_desc_t * ds_desc,  
                   l4_size_t size, l4_addr_t addr);
int lx_ds_add_ds(l4dm_dataspace_t ds, dsmlib_ds_desc_t * ds_desc, 
                 l4_size_t size, void * addr);
int lx_ds_search_equal(lx_task_t * task, void * data, l4_size_t size, 
                       unsigned long * ds_id);
int lx_ds_get_map_addr(lx_task_t * task, unsigned long ds_id, l4_addr_t * addr);


int lx_ds_do_get(lx_task_t * task, int pos, unsigned long ds_id,  lx_ds_t ** ds);
L4_INLINE int lx_ds_get(lx_task_t * task, unsigned long ds_id,  lx_ds_t ** ds);
L4_INLINE int lx_ds_get_pos(lx_task_t * task, int pos,  lx_ds_t ** ds);
void lx_ds_del(lx_task_t * task, unsigned long ds_id);

int lx_page_add(lx_ds_t * lxds, l4_offs_t offs, l4_addr_t addr, l4_uint32_t flags);
int lx_page_get(lx_ds_t * lxds, l4_offs_t offs, lx_page_t ** page);
void lx_page_del(lx_ds_t * lxds, l4_offs_t offs);

l4_addr_t lx_page_get_map_addr(lx_page_t * page);
void lx_page_release(lx_page_t * page);

int lx_page_fault(l4_threadid_t src, 
                  unsigned long ds_id, 
                  unsigned long offset, 
                  int rw,
                  l4_addr_t * map_addr);

/* stats.c */
void lx_stats_set_free(lx_task_t * task);
int lx_stats_get_task(lx_task_t * task, lx_task_stats_t ** stats);
lx_task_stats_t * lx_stats_get_free(lx_task_t * task);


/* event.c */
int lx_event_init(void);

/* hash.c*/
int lx_hash_start(void);
void lx_hash_register_page(lx_ds_t * ds, lx_page_t * page);

/* profile.c */
void lx_timer(void);
void lx_timer_init(void);

/* if_lxfreeze.c */
long lxif_close_ds(unsigned long ds_id);

/*******************************************************************************
 * implementations
 ******************************************************************************/ 
L4_INLINE int lx_task_add(l4_taskid_t task_id)	
{
 return lx_task_add_pos(task_id, -1);
}

L4_INLINE int lx_task_get_pos(int pos, lx_task_t ** task)
{
	return lx_task_do_get(L4_INVALID_ID, pos, task);
}

L4_INLINE int lx_task_get(l4_taskid_t task_id, lx_task_t ** task)
{
	return lx_task_do_get(task_id, -1, task);
}

L4_INLINE int lx_ds_get(lx_task_t * task, unsigned long ds_id,  lx_ds_t ** ds)
{
	return lx_ds_do_get(task, -1, ds_id, ds);
}

L4_INLINE int lx_ds_get_pos(lx_task_t * task, int pos,  lx_ds_t ** ds)
{
	return lx_ds_do_get(task, pos, 0, ds);
}

