#/* $Id: l4env_dummies.c 17260 2004-08-16 15:54:48Z reuther $ */
/*****************************************************************************/
/**
 * \file   loader/linux/fprov-l4/l4env_dummies.c
 * \brief  Dummmy implementations for some unused L4Env functions
 *
 * \date   02/15/2002
 * \author Lars Reuther <reuther@os.inf.tu-dresden.de>
 */
/*****************************************************************************/
/*
 * $Log$
 * Revision 1.5  2004/08/16 15:51:58  reuther
 * - adapted to changes in l4rm
 *
 * Revision 1.4  2004/08/13 15:51:15  reuther
 * - adapted to changes of l4rm_lookup()
 *
 * Revision 1.3  2004/02/18 22:34:15  reuther
 * - use LOG* macros instead of the obsolete macros from l4util
 *
 * Revision 1.2  2002/11/25 03:27:53  reuther
 * - adapted to new L4 integer types
 * - adapted to l4sys/l4util/l4env/dm_generic include changes
 *
 * Revision 1.1  2002/09/24 11:38:33  fm3
 * - moved here from linux subdir
 *
 * Revision 1.2  2002/03/08 08:21:06  fm3
 * - transfer ownership of resulting ds to calling client
 *
 * Revision 1.1  2002/02/18 03:48:13  reuther
 * Emulate some l4env functions.
 *
 */

#include <l4/sys/types.h>
#include <l4/env/errno.h>
#include <l4/log/l4log.h>
#include <l4/l4rm/l4rm.h>
#include <l4/env/env.h>
#include <l4/dm_phys/dm_phys.h>
#include <l4/names/libnames.h>

int
l4rm_lookup(const void * addr, l4_addr_t * map_addr, l4_size_t * map_size,
            l4dm_dataspace_t * ds, l4_offs_t * offset, l4_threadid_t * pager)
{
  return -L4_ENOTSUPP;
}

l4_threadid_t
l4env_get_default_dsm(void)
{
  l4_threadid_t dsm_id;

  if (!names_waitfor_name(L4DM_MEMPHYS_NAME,&dsm_id,60000))
    return L4_INVALID_ID;
  return dsm_id;
}
