#ifndef __ASM_L4__GENERIC__SUSPRES_H__
#define __ASM_L4__GENERIC__SUSPRES_H__

#include <linux/errno.h>
enum l4x_suspend_resume_state {
	L4X_SUSPEND,
	L4X_RESUME,
};

struct l4x_suspend_resume_struct {
	struct list_head list;
	void (*func)(enum l4x_suspend_resume_state);
};

#ifdef CONFIG_PM
void l4x_suspend_resume_register(void (*func)(enum l4x_suspend_resume_state),
                                 struct l4x_suspend_resume_struct *e);
#else
static inline void l4x_suspend_resume_register(void (*func)(enum l4x_suspend_resume_state),
                                               struct l4x_suspend_resume_struct *e)
{}
#endif

/* handle suspend to dataspace manager */
#ifdef CONFIG_SOFTWARE_SUSPEND_DS
extern int pm_suspend_ds(void);
void pm_suspend_ds_register(void);
void pm_suspend_ds_free_stack(l4_threadid_t);
void l4x_linux_suspend_ds(void);
#else
static inline int pm_suspend_ds(void) {return -EPERM;}
static inline void pm_suspend_ds_register(void){}
static inline void pm_suspend_ds_free_stack(l4_threadid_t thread){}
static inline void l4x_linux_suspend_ds(void){}
#endif

#endif /* ! __ASM_L4__GENERIC__SUSPRES_H__ */


