#ifndef __ASM_L4__GENERIC__DO_IRQ_H__
#define __ASM_L4__GENERIC__DO_IRQ_H__

#include <linux/spinlock.h>
#include <linux/thread_info.h>

#include <asm/generic/sched.h>
#include <asm/generic/task.h>
#include <asm/l4lxapi/irq.h>
#include <asm/l4lxapi/thread.h>
#include <asm/l4x/exception.h>
#include <l4/sys/ktrace.h>

#if 0
#define TBUF_LOG_IRQ(x)  do{ x; } while(0)
#else
#define TBUF_LOG_IRQ(x)
#endif

#ifdef CONFIG_L4_IRQ_PAGEFAULT_SAFE
static inline fastcall void l4x_do_IRQ_pgf_safe(int head)
{
  static int irq_zero_prio = 0, irq_count = 0, irq_have_lock = 0;
	
	l4semaphore_down(&l4lx_irq_sync_work_sem);
	switch(head) {
		case 0:
			irq_count++;
			if(l4semaphore_try_down(&l4lx_irq_sync_sem)) {
				/* L4Linux or other IRQ thread owns lock */
				if(!irq_zero_prio) {
					l4lx_thread_prio_set(linux_server_thread_id, 0);
					irq_zero_prio = 1;
				}
			}
			else 
				irq_have_lock = 1;

			TBUF_LOG_IRQ(fiasco_tbuf_log_3val("have/prio/cnt", irq_have_lock,
			             irq_zero_prio, irq_count));
			break;
		case 1:
			irq_count--;
			if(!irq_count) {
				if(irq_have_lock) {
					l4semaphore_up(&l4lx_irq_sync_sem);
					irq_have_lock = 0;
				}
				
				if(irq_zero_prio) {
					l4lx_thread_prio_set(linux_server_thread_id, CONFIG_L4_PRIO_SERVER_PROC);
					irq_zero_prio = 0;
				}
			}
	}
	l4semaphore_up(&l4lx_irq_sync_work_sem);
}

static inline void irq_sync_down(l4semaphore_t *sem) {
 l4semaphore_down(sem);
}

static inline void irq_sync_up(l4semaphore_t *sem) {
 l4semaphore_up(sem);
}

#else
static inline void l4x_do_IRQ_pgf_safe(int head){}
static inline void irq_sync_down(l4semaphore_t *sem) {}
static inline void irq_sync_up(l4semaphore_t *sem) {}
#endif


#ifdef ARCH_arm
unsigned int do_IRQ(int irq, struct pt_regs *regs);
#endif

static inline void l4x_do_IRQ(int irq, struct thread_info *ctx)
{
	unsigned long flags, old_cpu_state;
	struct pt_regs *r;
	int cpu = smp_processor_id();

	local_irq_save(flags);
	l4x_do_IRQ_pgf_safe(0);

	ctx->task = per_cpu(l4x_current_process, cpu);
	ctx->preempt_count = task_thread_info(per_cpu(l4x_current_process, cpu))->preempt_count;
	r = &per_cpu(l4x_current_process, cpu)->thread.regs;
	old_cpu_state = l4x_get_cpu_mode(r);
	l4x_set_cpu_mode(r, l4x_in_kernel() ? L4X_MODE_KERNEL : L4X_MODE_USER);
	do_IRQ(irq, &per_cpu(l4x_current_process, cpu)->thread.regs);
	l4x_set_cpu_mode(r, old_cpu_state);
	
	l4x_do_IRQ_pgf_safe(1);
	local_irq_restore(flags);

	l4x_wakeup_idle_if_needed();
}

#ifdef CONFIG_SMP
#include <asm/generic/smp.h>

static inline void l4x_do_IPI(int vector, struct thread_info *ctx)
{
	unsigned long flags, old_cpu_state;
	struct pt_regs *r;
	int cpu = smp_processor_id();

	local_irq_save(flags);
	ctx->task = per_cpu(l4x_current_process, cpu);
	ctx->preempt_count = task_thread_info(per_cpu(l4x_current_process, cpu))->preempt_count;
	r = &per_cpu(l4x_current_process, cpu)->thread.regs;
	old_cpu_state = l4x_get_cpu_mode(r);
	l4x_set_cpu_mode(r, l4x_in_kernel() ? L4X_MODE_KERNEL : L4X_MODE_USER);
	do_l4x_smp_process_IPI(vector, &per_cpu(l4x_current_process, cpu)->thread.regs);
	l4x_set_cpu_mode(r, old_cpu_state);
	local_irq_restore(flags);

	l4x_wakeup_idle_if_needed();
}
#endif

#endif /* ! __ASM_L4__GENERIC__DO_IRQ_H__ */
