#include <linux/sched.h>

void block_arch(void)
{
	asm volatile(
		/* block forever */
		"1:                      \n\t"
		"movl  $0xffffffff,%eax \n\t"  /* EAX = -1, no send operation */
		"xorl  %ebp,%ebp       \n\t"  /* EBP = 0, short closed wait */
		"xorl  %esi,%esi       \n\t"  /* ESI = 0, dest = nil id */
		"xorl  %ecx,%ecx       \n\t"  /* ECX = 0, timeout never */

		/* IPC */
		"int $0x30\n\t"       /* no sysenter, as this potentially
		                         accesses the stack */

		"jmp   1b                \n\t"
		);
}

void linux_arch(struct task_struct *prev)
{

	l4x_fiasco_gdt_entry_offset = fiasco_gdt_get_entry_offset();
	
	asm volatile("movl %%ds,  %%eax \n"
	             "movl %%eax, %%fs  \n"  // fs == ds
	             "xorl %%eax, %%eax \n"
	             "movl %%eax, %%gs  \n"  // clear gs
		     : : : "eax", "memory");
}
