/* $Id:$ */
/*******************************************************************************/
/*
 * \file   unimplemented.c
 * \brief  unimplemented interface calls
 *
 * \date   Makefile
 * \author Sebastian Sumpf <sumpf@os.inf.tu-dresden.de>
 */
/*******************************************************************************/
/* (c) 2007 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details.
 */
/* unneeded dm_mem/dm_generic interface calls */
#include "lxMir-server.h"
#include <l4/log/l4log.h>
#include <l4/env/errno.h>

#define __ERROR__ LOG_Enter();enter_kdebug("FIX ME: not implemented");
#define __RET__ return -L4_ENOTSUPP;
#define __ERROR_RET__ __ERROR__ __RET__

long
if_l4dm_generic_close_all_component (CORBA_Object _dice_corba_obj,
                                     const l4_threadid_t *client,
                                     unsigned long flags,
                                     CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}


long
if_l4dm_generic_revoke_component (CORBA_Object _dice_corba_obj,
                                  unsigned long ds_id,
                                  const l4_threadid_t *client,
                                  unsigned long flags,
                                  CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

long
if_l4dm_generic_check_rights_component (CORBA_Object _dice_corba_obj,
                                        unsigned long ds_id,
                                        unsigned long flags,
                                        CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}


long
if_l4dm_generic_copy_component (CORBA_Object _dice_corba_obj,
                                unsigned long ds_id,
                                unsigned long src_offs,
                                unsigned long dst_offs,
                                unsigned long num,
                                unsigned long flags,
                                const char* name,
                                l4dm_dataspace_t *copy,
                                CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}


long
if_l4dm_generic_set_name_component (CORBA_Object _dice_corba_obj,
                                    unsigned long ds_id,
                                    const char* name,
                                    CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

long
if_l4dm_generic_get_name_component (CORBA_Object _dice_corba_obj,
                                    unsigned long ds_id,
                                    char* *name,
                                    CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

long
if_l4dm_generic_show_ds_component (CORBA_Object _dice_corba_obj,
                                   unsigned long ds_id,
                                   CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

void
if_l4dm_generic_list_component (CORBA_Object _dice_corba_obj,
                                const l4_threadid_t *owner,
                                unsigned long flags,
                                CORBA_Server_Environment *_dice_corba_env)
{__ERROR__}

long
if_l4dm_mem_is_contiguous_component (CORBA_Object _dice_corba_obj,
                                     unsigned long ds_id,
                                     long *is_cont,
                                     CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

long
if_l4dm_mem_lock_component (CORBA_Object _dice_corba_obj,
                            unsigned long ds_id,
                            unsigned long offset,
                            unsigned long size,
                            CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

long
if_l4dm_mem_unlock_component (CORBA_Object _dice_corba_obj,
                              unsigned long ds_id,
                              unsigned long offset,
                              unsigned long size,
                              CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

long
if_l4dm_mem_info_component (CORBA_Object _dice_corba_obj,
                            unsigned long ds_id,
                            l4_size_t *size,
                            l4_threadid_t *owner,
                            char* *name,
                            l4_uint32_t *next_id,
                            CORBA_Server_Environment *_dice_corba_env)
{__ERROR_RET__}

void
if_l4dm_lxfreeze_stats_get_component (CORBA_Object _dice_corba_obj,
                                      void **stats,
                                      l4_size_t *size,
                                      CORBA_Server_Environment *_dice_corba_env)
{__ERROR__}


void
if_l4dm_lxfreeze_timer_component (CORBA_Object _dice_corba_obj,
                                  CORBA_Server_Environment *_dice_corba_env){}
