/* $Id: config.h,v 1.2 2007/01/25 15:13:06 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file config.h
 *  \brief Freezer configuration file 
 * 
 *  \date 12/18/06 18:26:18 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
#ifndef __LXMIR_CONFIG_H__
#define __LXMIR_CONFIG_H__

///name of freezer
#define LX_FREEZE           "lxfreeze"

///name of migration back end
#define LX_MIR              "lxMir"

///Max. number of Linux instances
#define LX_MAX_INSTANCES    10

///Max. number of datapaces per instance
#define LX_MAX_DS           50

///Max. total numver of dataspaces
#define FREEZE_MAX_DS       256

///Location of L4ENV infopage
#define L4ENV_INFOPAGE_AT   0x7000

///Max. size of slab caches
#define LX_MAX_SLAB_SIZE    (4 << 20)

///Max. COW area size
#define LX_COW_AREA_SIZE    (256 << 20)

#endif /* __LXMIR_CONFIG_H__ */
