/**
 * \file   ldso/lib/ldso/emul_linux.h
 * \brief  Adaption layer for Linux system calls to L4env
 *
 * \date   2005/05/12
 * \author Frank Mehnert <fm3@os.inf.tu-dresden.de> */

/* (c) 2005 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details. */

#ifndef _EMUL_LINUX_H
#define _EMUL_LINUX_H

#include <l4/sys/l4int.h>
#include <l4/dm_mem/dm_mem.h>
#ifdef ARCH_amd64
#define MMAP_START	0x70000000 
#define MMAP_END	0x78000000 - MMAP_SAVE_SIZE
#else
#define MMAP_START	0xA0000000 
#define MMAP_END	0xA8000000 - MMAP_SAVE_SIZE
#endif


#if (__GNUC__ == 3 && __GNUC_MINOR__ >= 3) || __GNUC__ > 3
#define HIDDEN __attribute__((visibility("hidden")))
#else
#define HIDDEN
#endif

#define MMAP_ENTRIES	64

/* l4exc.info.id of mmap page and size */
#define MMAP_SAVE_EXEC_ID 0xFFFF
#define MMAP_SAVE_SIZE    L4_PAGESIZE

struct mmap_region_save_t 
{
  l4_addr_t        addr;
  l4_size_t        size;
  l4dm_dataspace_t ds;
};

typedef struct mmap_infopage_t 
{
  int                        section_num;
  struct mmap_region_save_t  section[MMAP_ENTRIES];
} mmap_infopage_t;

void      _dl_seek(int fd, unsigned pos) HIDDEN;
void*     _dl_alloc_pages(l4_size_t size, l4_addr_t *phys,
			  const char *name) HIDDEN;
void      _dl_free_pages(void *addr, l4_size_t size) HIDDEN;
void      _dl_mmap_list_regions(int only_unseen);
int       mmap_save(l4dm_dataspace_t *ds, l4_addr_t *addr, l4_size_t *size);
#endif
