INTERFACE:

#include "mapping_tree.h"
#include "mappable.h"
#include "obj_helping_lock.h"
#include "kmem_slab.h"

class Ram_quota;

class U_lock : public Mappable
{
private:
  typedef slab_cache_anon Allocator;

  Ram_quota *_q;
  unsigned long _cnt;
  mutable Obj_helping_lock _l;
public:
  Context *lockers;

public:
  virtual ~U_lock() {}
};


IMPLEMENTATION:

PUBLIC inline
U_lock::U_lock(Ram_quota *q) : _q(q), _cnt(0), lockers(0) {}

PUBLIC inline
Obj_helping_lock::Lock_res 
U_lock::lock()
{ return _l.lock(); }

PUBLIC inline
void
U_lock::clear()
{ _l.clear(); }

PUBLIC inline
unsigned
U_lock::dec_ref_cnt()
{
  Lock_guard<Cpu_lock> guard(&cpu_lock);
  --_cnt;
  if (_cnt == 0 && Mappable::no_mappings())
    return 0;
  else
    return 1;
}

PUBLIC inline
void
U_lock::inc_ref_cnt()
{ ++_cnt; }

PUBLIC inline
bool 
U_lock::no_mappings() const
{
  Lock_guard<Cpu_lock> guard(&cpu_lock);
  if (Mappable::no_mappings())
    {
      _l.invalidate();
      return !_cnt;
    }
  return 0;
}



PUBLIC static
U_lock*
U_lock::alloc(Ram_quota *q)
{
  void *nq;
  if (q->alloc(sizeof(U_lock)) && (nq = allocator()->alloc()))
    return new (nq) U_lock(q);

  return 0;
}

PUBLIC
void *
U_lock::operator new (size_t, void *p)
{ return p; }

PUBLIC 
void
U_lock::operator delete (void *_l)
{
  U_lock *l = reinterpret_cast<U_lock*>(_l);
  if (l->_q)
    l->_q->free(sizeof(U_lock));

  allocator()->free(l);
}

PRIVATE static inline NOEXPORT NEEDS["kmem_slab.h"]
U_lock::Allocator *
U_lock::allocator()
{
  static Allocator* slabs = 
    new Kmem_slab_simple (sizeof (U_lock), sizeof (Mword), "U_lock");

  return slabs;
}

