/**
 *    \file    dice/src/fe/FEResourceProperty.cpp
 *    \brief    contains the implementation of the class CFEResourceProperty
 *
 *    \date    04/25/2004
 *    \author    Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/* Copyright (C) 2001-2003 by
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */
#include "fe/FEResourceProperty.h"
#include "File.h"

IMPLEMENT_DYNAMIC(CFEResourceProperty)

CFEResourceProperty::CFEResourceProperty(String *pName, String *pValue)
 : CFEIdentifier(*pName)
{
    IMPLEMENT_DYNAMIC_BASE(CFEResourceProperty, CFEIdentifier);
    if (pValue)
        m_sValue = *pValue;
}

CFEResourceProperty::CFEResourceProperty(CFEResourceProperty & src)
 : CFEIdentifier(src)
{
    IMPLEMENT_DYNAMIC_BASE(CFEResourceProperty, CFEIdentifier);
    m_sValue = src.m_sValue;
}

/** destroys the resource property object */
CFEResourceProperty::~CFEResourceProperty()
{
}

/**    \brief creates a copy of this object
 *    \return a reference to the newly created copy
 */
CObject* CFEResourceProperty::Clone()
{
    return new CFEResourceProperty(*this);
}

/**    \brief serialize the property to a file
 *    \param pFile the file to write to
 */
void CFEResourceProperty::Serialize(CFile *pFile)
{
    *pFile << "\t<property>\n";
    pFile->IncIndent();
    *pFile << "\t<name>" << m_sName << "</name>\n";
    *pFile << "\t<value>" << m_sValue << "</value>\n";
    pFile->DecIndent();
    *pFile << "\t</property>\n";
}

/*!
    \fn CFEResourceProperty::GetValue()
    \return the content of the resource properties value
 */
String CFEResourceProperty::GetValue()
{
    return m_sValue;
}
