/**
 *    \file    dice/src/be/l4/L4BEResourceRequestFunction.cpp
 *    \brief    contains the implementation of the class CL4BEResourceRequestFunction
 *
 *    \date    04/25/2004
 *    \author    Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/* Copyright (C) 2001-2003 by
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */
#include "L4BEResourceRequestFunction.h"
#include "be/BEFile.h"
#include "be/BEContext.h"
#include "be/BETypedDeclarator.h"
#include "be/BEType.h"

IMPLEMENT_DYNAMIC(CL4BEResourceRequestFunction);

CL4BEResourceRequestFunction::CL4BEResourceRequestFunction()
 : CBEResourceRequestFunction()
{
    IMPLEMENT_DYNAMIC_BASE(CL4BEResourceRequestFunction, CBEResourceRequestFunction);
}

CL4BEResourceRequestFunction::CL4BEResourceRequestFunction(CL4BEResourceRequestFunction &src)
 : CBEResourceRequestFunction(src)
{
    IMPLEMENT_DYNAMIC_BASE(CL4BEResourceRequestFunction, CBEResourceRequestFunction);
}

/** destroys the instance of this object */
CL4BEResourceRequestFunction::~CL4BEResourceRequestFunction()
{
}

/**    \brief writes the body of this function
 *    \param pFile the file to write to
 *    \param pContext the context of the write call
 *
 * In ths implementation we have to call the qos_mgr client lib function
 * to make a resource reservation and then hand the received handles back
 * to the user.
 */
void CL4BEResourceRequestFunction::WriteBody(CBEFile *pFile, CBEContext *pContext)
{
    /* thread id of myself */
    *pFile << "\tl4_threadid_t my_id = l4_myself();\n";
    *pFile << "\tchar* request;\n";
    *pFile << "\tqos_reservation_handle_t qos_handle;\n";
    // handles
    m_pReturnVar->WriteInitDeclaration(pFile, String("0"), pContext);
    *pFile << "\n";


    /* init request */
    *pFile << "\trequest = \"" << m_sRequest << "\";\n\n";

    /* call qosmgr */
    *pFile << "\tif (qos_mgr_negotiate(&myid, request, &handles, &qos_handle))\n";
    *pFile << "\t{\n";
    pFile->IncIndent();
    *pFile << "\tLOG(\"reservation failed\");\n";
    *pFile << "\treturn 0;\n";
    pFile->DecIndent();
    *pFile << "\t}\n\n";

    WriteReturn(pFile, pContext);
}
