/* $Id: config.h,v 1.2 2007/01/25 15:13:06 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file config.h
 *  \brief Freezer configuration file 
 * 
 *  \date 12/18/06 18:26:18 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
///Max. number of Linux instances
#define LX_MAX_INSTANCES    50

///Max. number of datapaces per instance
#define LX_MAX_DS           50

///Location of L4ENV infopage
#define L4ENV_INFOPAGE_AT   0x7000

///Location of mmap info page (compile ldso with MMAP_SAVE=1)
#define MMAP_INFOPAGE_AT    0xA7FFF000

///Max. # of re-tries to map an RW page RO (max is 15 == 4 bit)
#define LX_RO_MAP_RETRY     3

///Max. size of slab caches
#define LX_MAX_SLAB_SIZE    (4 << 20)

///Max. COW area size
#define LX_COW_AREA_SIZE    (256 << 20)

///Hash levels 
//supported are values 1, 2, 3, and 0 to disable hashing
#define LX_HASH_LEVELS      3

///Hashing-thread priority
#define LX_HASH_PRIO        0x1

