/* $Id:$ */
/*******************************************************************************/
/*
 * \file   if_net_lxmir.c
 * \brief  lxmir interface implementation
 *
 * \date   2007-09-27
 * \author Sebastian Sumpf <sumpf@os.inf.tu-dresden.de>
 */
/*******************************************************************************/
/* (c) 2007 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details.
 */
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <pthread.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>


#include <l4/lxMir/lxMir-client.h> 
#include <l4/util/macros.h>
#include "lxMirback_end-server.h"
#include "__globals.h"
#include <l4/sys/syscalls.h>

int
if_net_lxmir_migrate_component (CORBA_Object _dice_corba_obj,
                                const l4_taskid_t *task_id,
                                const char *file,
                                int recv,
                                CORBA_Server_Environment *_dice_corba_env)
{
	lx_task_t *task;
	pthread_t pth;
	mode_t mask = S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH;
	int fd, f_flags, err, read_offs;
	void * thread_func;
	l4_size_t size;
	
	/* test permissions */
	if(recv && access(file, R_OK) < 0) {
		fprintf(stderr, "Error: Failed access check %s\n", file);
		return errno;
	}
	
	if((task = (lx_task_t *)malloc(sizeof(lx_task_t))) == NULL)
		return ENOMEM;

	f_flags = (recv)?O_RDONLY | O_NONBLOCK 
	                : O_RDWR | O_CREAT | O_TRUNC | O_NONBLOCK;
	if((fd = open(file, f_flags, mask)) < 0) {
		fprintf(stderr, "Error: Failed to open %s\n", file);
		free((void*)task);
		return errno;
	}
	
	if(recv) {
		thread_func = thread_restore;
		err = 0;

		task->fd = fd;
		/* read lx_task from file */
		for(size = sizeof(lx_task_t), read_offs = 0; 
		    size > 0; 
		    size -= err, read_offs += err) {

			if((err = read(fd, (void*)(task + read_offs), size)) < 0) {
				free((void*)task);
				fprintf(stderr, "Error: file read error\n");
				return errno;
			}
		}
	}
	else {
		thread_func = thread_save;
	}
	
	task->caller_id      = *_dice_corba_obj;
	task->task_id        = *task_id;
	task->back_server_id = l4_myself();
	task->fd             = fd;

	if((err = pthread_create(&pth, 0, (void*(*)(void*))thread_func, 
	                         (void*)task))) {
		free((void*)task);
		return err;
	}

	return 0;
}
