/* $Id: __hash.h,v 1.2 2007/01/25 15:13:06 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file __hash.h
 *  \brief Bobs hash function prottypes, see src/lookup3.c 
 * 
 *  \date 12/18/06 14:37:19 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/

l4_uint32_t hashlittle(const void *key, size_t length, l4_uint32_t initval);
l4_uint32_t hashword(const l4_uint32_t *k, size_t length, l4_uint32_t initval);
void hashlittle2(const void *key, size_t length, l4_uint32_t *pc, l4_uint32_t *pb);
l4_uint32_t hashbig( const void *key, size_t length, l4_uint32_t initval);

/*******************************************************************************
 *** hash level definitions 
 ******************************************************************************/

typedef struct hash_level_t {
	l4_size_t length;
	l4_offs_t offset;
	l4_uint64_t mask;
	l4_uint32_t shift;
	l4_uint32_t bits;
} hash_level_t;

