/* $Id: lxfreeze.h,v 1.2 2007/01/12 12:00:59 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file lxfreeze.h
 *  \brief Linux freezer library 
 * 
 *  \date 11/12/06 19:44:37 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/
#ifndef __LXMIR_LXFREEZE_H__
#define __LXMIR_LXFREEZE_H__

#include <l4/dm_generic/dm_generic.h>
#include "config.h"
#include <l4/sys/types.h>
#include <l4/lxfreeze/lxfreeze.h>

#define DS_INFO_INVALID 0
#define DS_INFO_VALID   1
#define DS_INFO_VIRT    2

typedef struct lx_ds_info_t {
	unsigned long ds_id;
	l4_size_t     size;
	l4_uint8_t    flags;
	l4_addr_t     virt_addr;
	l4_size_t     virt_size;
	char          name[L4DM_DS_NAME_MAX_LEN];
} lx_ds_info_t;

#endif
