/*
 * This file is distributed along with the 'dice' package. It contains
 * constants, types and functions needed by the code generated by dice.
 *
 */

#ifndef __DICE_DICE_H__
#define __DICE_DICE_H__

#if !defined(L4API_l4v2) && !defined(L4API_l4x0) && !defined(L4API_l4x2) && !defined(L4API_l4v4) && !defined(L4API_linux)
#warning no L4 API set
#define L4API_l4v2
#endif

/* common macros */

// needed for str* functions
#if !defined(LINUX_ON_L4) && !defined(CONFIG_L4_LINUX) && !defined(DDE_LINUX)
#if !defined(L4API_l4x2) && !defined(L4API_l4v4)
#include <string.h>
#endif
#endif

#undef _dice_alloca
#ifdef __GNUC__
#define _dice_alloca(size)	                        \
  ((void*)((((unsigned long)__builtin_alloca ((size)    \
    + sizeof (unsigned long))) + sizeof (unsigned long) \
    -1) & ~(sizeof (unsigned long) -1)))
#endif

#undef _dice_memcpy
#ifdef __GNUC__
#define _dice_memcpy(to,from,size)   \
    __builtin_memcpy(to, from, size)
#else
#define _dice_memcpy(to,from,size)   \
    { int _i = size; char *_f = (char*)from, *_t = (char*)to; while (_i--) *_t++= *_f++; }
#endif

#undef _dice_max
#ifdef __GNUC__
#define _dice_max(a,b) \
    ({int _a = (a), _b = (b); _a > _b ? _a : _b; })
#else
#define _dice_max(a,b) \
    ((a) > (b) ? (a) : (b))
#endif

// do some optimization if possible
#if (__GNUC__ >= 3)
#define DICE_EXPECT_TRUE(exp)  __builtin_expect((exp),1)
#define DICE_EXPECT_FALSE(exp) __builtin_expect((exp),0)
#else
#define DICE_EXPECT_TRUE(exp)  (exp)
#define DICE_EXPECT_FALSE(exp) (exp)
#endif

#define DICE_REPLY    1
#define DICE_NO_REPLY 2
#define DICE_DEFERRED_REPLY 2
#define DICE_NEVER_REPLY 3

#ifndef DICE_IID_BITS
#if !defined(L4API_l4x2) && !defined(L4API_l4v4)
#define DICE_IID_BITS 20
#else
#define DICE_IID_BITS 12
#endif
#endif

#ifndef DICE_FID_MASK
#if !defined(L4API_l4x2) && !defined(L4API_l4v4)
#define DICE_FID_MASK 0xfffff
#else
#define DICE_FID_MASK 0xfff
#endif
#endif

#ifndef DICE_STR
#define __DICE_STR(x) #x
#define DICE_STR(x) __DICE_STR(x)
#endif

#include "dice/dice-corba-types.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * declares CORBA_alloc and CORBA_free - implementation has to be user provided
 */
void* CORBA_alloc(unsigned long size);
void CORBA_free(void *ptr);

#ifdef __cplusplus
}
#endif


/* defines needed in environment initialization */
#define CORBA_NO_EXCEPTION      0
#define CORBA_USER_EXCEPTION    1
#define CORBA_SYSTEM_EXCEPTION  2

#define CORBA_DICE_EXCEPTION_NONE 0
#define CORBA_DICE_EXCEPTION_WRONG_OPCODE 1
#define CORBA_DICE_EXCEPTION_IPC_ERROR 2
#define CORBA_DICE_INTERNAL_IPC_ERROR 3
#define CORBA_DICE_EXCEPTION_COUNT 4

#if defined(L4API_linux)
#include "dice/dice-sockets.h"
#else
#if defined(L4API_l4v2)
#include "dice/dice-l4-v2.h"
#else
#if defined(L4API_l4x0)
#include "dice/dice-l4-x0.h"
#else
#if defined(L4API_l4x2) || defined(L4API_l4v4)
#include "dice/dice-l4-v4.h"
#endif // L4X2
#endif // L4X0
#endif // L4V2
#endif // SOCKET

/* Convenience macros.
 *
 * They're here, because we need dice_default_environment and
 * dice_default_server_environment to be declared, which are API dependant. The
 * macros however are independent.
 */
#ifndef DICE_DECLARE_ENV
#ifdef __cplusplus
#define DICE_DECLARE_ENV(env) CORBA_Environment env
#else
#define DICE_DECLARE_ENV(env) CORBA_Environment env = dice_default_environment
#endif /* __cplusplus */
#endif /* !DICE_DECLARE_ENV */

#ifndef DICE_DECLARE_SERVER_ENV
#ifdef __cplusplus
#define DICE_DECLARE_SERVER_ENV(env) CORBA_Server_Environment env
#else
#define DICE_DECLARE_SERVER_ENV(env) \
             CORBA_Server_Environment env = dice_default_server_environment
#endif /* __cplusplus */
#endif /* !DICE_DECLARE_SERVER_ENV */

#ifdef __cplusplus
extern "C" {
#endif

/* common functions for the CORBA environement */
static const CORBA_char* __CORBA_Exception_Repository[CORBA_DICE_EXCEPTION_COUNT+1] = { "none", "wrong opcode", "ipc error", "internal ipc error", 0 };

DICE_INLINE
void CORBA_exception_free(CORBA_Environment *ev)
{
    if (DICE_HAS_EXCEPTION(ev))
    {
       	//ev->free(DICE_EXCEPTION_PARAM(ev));
	DICE_EXCEPTION_PARAM(ev) = 0;
    }
    DICE_EXCEPTION_MAJOR(ev) = CORBA_NO_EXCEPTION;
    DICE_EXCEPTION_MINOR(ev) = CORBA_DICE_EXCEPTION_NONE;
}

DICE_INLINE
void CORBA_exception_set(
    CORBA_Environment *ev,
    CORBA_exception_type major,
//    CORBA_char *except_repos_id,
    CORBA_exception_type repos_id,
    void *param)
{
    CORBA_exception_free(ev);
    DICE_EXCEPTION_MAJOR(ev) = major;
    if (major != CORBA_NO_EXCEPTION)
    {
	DICE_EXCEPTION_MINOR(ev) = repos_id;
	DICE_EXCEPTION_PARAM(ev) = param;
    }
}

DICE_INLINE
const CORBA_char* CORBA_exception_id(CORBA_Environment *ev)
{
    // string can be found using repository id (repos_id)
    if ((DICE_EXCEPTION_MAJOR(ev) == CORBA_SYSTEM_EXCEPTION) &&
	(DICE_EXCEPTION_MINOR(ev) < CORBA_DICE_EXCEPTION_COUNT))
	return __CORBA_Exception_Repository[DICE_EXCEPTION_MINOR(ev)];
    else
	return 0;
}

DICE_INLINE
void* CORBA_exception_value(CORBA_Environment *ev)
{
    return DICE_EXCEPTION_PARAM(ev);
}

DICE_INLINE
CORBA_any* CORBA_exception_as_any(CORBA_Environment *ev)
{
  // not supported
  return 0;
}

/*************************************************************
 * For the server environement as well
 *************************************************************/
DICE_INLINE
void CORBA_server_exception_free(CORBA_Server_Environment *ev)
{
    if (DICE_HAS_EXCEPTION(ev))
    {
	//ev->free(DICE_EXCEPTION_PARAM(ev));
	DICE_EXCEPTION_PARAM(ev) = 0;
    }
    DICE_EXCEPTION_MAJOR(ev) = CORBA_NO_EXCEPTION;
    DICE_EXCEPTION_MINOR(ev) = CORBA_DICE_EXCEPTION_NONE;
}

DICE_INLINE
void CORBA_server_exception_set(
    CORBA_Server_Environment *ev,
    CORBA_exception_type major,
    // CORBA_char *except_repos_id,
    CORBA_exception_type repos_id,
    void *param)
{
    CORBA_server_exception_free(ev);
    DICE_EXCEPTION_MAJOR(ev) = major;
    if (major != CORBA_NO_EXCEPTION)
    {
	DICE_EXCEPTION_MINOR(ev) = repos_id;
	DICE_EXCEPTION_PARAM(ev) = param;
    }
}

DICE_INLINE
const CORBA_char* CORBA_server_exception_id(CORBA_Server_Environment *ev)
{
    // string can be found using repository id (repos_id)
    if ((DICE_EXCEPTION_MAJOR(ev) == CORBA_SYSTEM_EXCEPTION) &&
	(DICE_EXCEPTION_MINOR(ev) < CORBA_DICE_EXCEPTION_COUNT))
	return __CORBA_Exception_Repository[DICE_EXCEPTION_MINOR(ev)];
    else
	return 0;
}

DICE_INLINE
void* CORBA_server_exception_value(CORBA_Server_Environment *ev)
{
    return DICE_EXCEPTION_PARAM(ev);
}

DICE_INLINE
CORBA_any* CORBA_server_exception_as_any(CORBA_Server_Environment *ev)
{
  // not supported
  return 0;
}

/***********************************************************************
 * DICE specific environment functions 
 ***********************************************************************/
DICE_INLINE
int dice_set_ptr(CORBA_Server_Environment *ev, void* ptr)
{
  if (!ev || !ptr)
    return 1;
  if (ev->ptrs_cur >= DICE_PTRS_MAX)
    return 1;
  ev->ptrs[ev->ptrs_cur++] = ptr;
  return 0;
}

DICE_INLINE
void* dice_get_last_ptr(CORBA_Server_Environment *ev)
{
  void *ptr = 0;
  if (!ev)
    return ptr;
  if (ev->ptrs_cur == 0 ||
      ev->ptrs_cur > DICE_PTRS_MAX)
    return ptr;
  ptr = ev->ptrs[--ev->ptrs_cur];
  ev->ptrs[ev->ptrs_cur] = 0;
  return ptr;
}

DICE_INLINE
void* dice_get_nth_ptr(CORBA_Server_Environment *ev, int i)
{
  void *ptr = 0;
  if (!ev)
    return 0;
  if (i < 0 || i >= ev->ptrs_cur)
    return 0;
  ptr = ev->ptrs[i];
  /* move ptrs after i to collate array */
  while (i < ev->ptrs_cur)
    {
      ev->ptrs[i] = ev->ptrs[i+1];
      i++;
    }
  ev->ptrs_cur--;
  return ptr;
}

DICE_INLINE
const void* dice_get_ptr(CORBA_Server_Environment *ev, const void* p)
{
  int i;
  if (!ev)
    return 0;
  for (i = 0; i < ev->ptrs_cur; i++)
    {
      if (p == ev->ptrs[i])
        break;
    }
  if (i == ev->ptrs_cur)
    return 0;
  /* move ptrs after i to collate array */
  while (i < ev->ptrs_cur)
    {
      ev->ptrs[i] = ev->ptrs[i+1];
      i++;
    }
  ev->ptrs_cur--;
  return p;
}

#ifdef __cplusplus
}
#endif

#endif /* __DICE_DICE_H__ */
