/* $Id: locate.c,v 1.2 2007/01/12 12:00:59 cbass Exp $ */
/*****************************************************************************/
/**
 *  \file locate.c
 *  \brief locate freezer thread 
 * 
 *  \date 11/12/06 19:24:11 CET
 *  \author Sebastian Sumpf <Sebastian.Sumpf@inf.tu-dresden.de>
 */ 
/******************************************************************************/

#include <l4/names/libnames.h>
#include <l4/env/errno.h>
#include <l4/lxfreeze/lxfreeze.h>
#include <l4/lxfreeze/lxfreeze-client.h>
#include "internal.h"

l4_threadid_t _freezer_id = L4_INVALID_ID;
l4_threadid_t _freezer_pager_id = L4_INVALID_ID;

int __find_freezer_id(void)
{
	if(l4_is_invalid_id(_freezer_id))
	{
		int cnt = FREEZER_RETRY;

		while(!names_waitfor_name(LX_FREEZE, &_freezer_id, 1000) && cnt--){}

		if(l4_is_invalid_id(_freezer_id))
				return -L4_ENOTFOUND;
	}	
	return 0;
}
int __find_freezer_pager_id(void)
{
	static CORBA_Environment env = dice_default_environment;
	int ret;
	l4_threadid_t id;
	if(!l4_is_invalid_id(_freezer_pager_id))
		return 0;
	
	if((ret = __find_freezer_id()))
		return ret;
	
	ret =
		if_l4dm_lxfreeze_get_start_pager_call(&_freezer_id, &id,  &env);
	_freezer_pager_id = id;

	if(l4_is_invalid_id(_freezer_pager_id))
		return -L4_ENOTFOUND;
	
	return 0;
}

