#include <l4/sys/types.h>
#include "config.h"

typedef struct lx_task_stats_t {
	l4_taskid_t task_id;
	l4_uint32_t page_cnt;
} lx_task_stats_t;

typedef struct lx_stats_t {
	l4_uint32_t page_frozen;
	l4_uint32_t page_ref;
	l4_uint32_t page_copied;
	l4_uint32_t mem_overhead;
	l4_uint32_t mem_usage;
	l4_uint32_t mem_free;
	l4_uint32_t mem_total;
	l4_uint32_t hash_collisions[LX_HASH_LEVELS];
	l4_uint32_t hash_matches[LX_HASH_LEVELS];
	l4_uint32_t hash_hot_cnt;
	int hash_len;
	lx_task_stats_t task[LX_MAX_INSTANCES];
	int task_len;
} lx_stats_t;


/** \brief Return pointer to freezer statistics */
/* lxfreeze specific library call */
void lxfreeze_get_stats(lx_stats_t * stats);
